package com.bizvane.payment.feign.api;

import com.bizvane.payment.feign.vo.NotifyOrderPayVO;
import com.bizvane.payment.feign.vo.req.*;
import com.bizvane.payment.feign.vo.resp.PrepayOrderRespVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value = "${feign.client.payment.name}", path = "${feign.client.payment.path}/wechatPay")
public interface UnifiedPaymentPayFeign {

    @PostMapping("/prepareOrder")
    ResponseData<PrepayOrderRespVO> prepareOrder(@RequestBody PrepareOrderReqVO reqVO);

    @PostMapping("/queryOrder")
    ResponseData<NotifyOrderPayVO> queryOrder(@RequestBody QueryOrderPayReqVO reqVO);

    @PostMapping("/closeOrder")
    ResponseData<Boolean> closeOrder(@RequestBody CloseOrderPayReqVO reqVO);

}
