package com.bizvane.payment.feign.api;

import com.bizvane.payment.feign.vo.req.*;
import com.bizvane.payment.feign.vo.resp.IcbcPayFrozenRecordPageRespVO;
import com.bizvane.payment.feign.vo.resp.IcbcPayFrozenRecordPullRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 工行入账记录
 */
@FeignClient(value = "${feign.client.payment.name}", path = "${feign.client.payment.path}/icbcPayFrozenRecord")
public interface IcbcPayFrozenRecordFeign {

    /**
     * 工行入账记录分页
     * @param reqVO
     * @return
     */
    @PostMapping("/page")
    ResponseData<PageInfo<IcbcPayFrozenRecordPageRespVO>> page(@RequestBody IcbcPayFrozenRecordPageReqVO reqVO);

    /**
     * 工行入账记录解冻
     * @param reqVO
     * @return
     */
    @PostMapping("/thaw")
    ResponseData<Boolean> thaw(@RequestBody @Validated IcbcPayFrozenRecordThawReqVO reqVO);

    /**
     * 工行入账记录分账
     * @param reqVO
     * @return
     */
    @PostMapping("/split")
    ResponseData<Boolean> split(@RequestBody @Validated IcbcPayFrozenRecordSliptReqVO reqVO);

    /**
     * 工行入账记录新增/更新
     * @param reqVO
     * @return
     */
    @PostMapping("/saveOrUpdate")
    ResponseData<Boolean> saveOrUpdate(@RequestBody @Validated IcbcPayFrozenRecordAddReqVO reqVO);

    /**
     * 工行入账记录远程拉取列表
     * @param reqVO
     * @return
     */
    @PostMapping("/pull")
    ResponseData<PageInfo<IcbcPayFrozenRecordPullRespVO>> pull(@RequestBody @Validated IcbcPayFrozenRecordPullReqVO reqVO);

}
