package com.bizvane.payment.feign.vo.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

@Data
public class BaseMerchantVO {

    @ApiModelProperty("商户支付配置系统编号code")
    @NotBlank(message = "商户支付配置系统编号code不能为空")
    private String paymentMerchantConfigCode;

    @ApiModelProperty("支付场景类型 PaymentChannelTypeEnum")
    @NotBlank(message = "支付场景类型不能为空 PaymentChannelTypeEnum")
    private String channelType;
}
