/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.payment.api.service.impl;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bizvane.payment.api.config.WechatPayProperties;
import com.bizvane.payment.api.service.CommonService;
import com.bizvane.payment.api.service.MqWechatPayRefundNotifyService;
import com.bizvane.payment.domain.domain.po.TIntegralOrderRefundTradeRecord;
import com.bizvane.payment.domain.service.TIntegralOrderRefundTradeRecordService;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.wechat.pay.java.core.RSAAutoCertificateConfig;
import com.wechat.pay.java.core.exception.ValidationException;
import com.wechat.pay.java.service.refund.model.RefundNotification;
import javax.servlet.http.HttpServletRequest;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class MqWechatPayRefundNotifyServiceImpl
implements MqWechatPayRefundNotifyService {
    private static final Logger log = LoggerFactory.getLogger(MqWechatPayRefundNotifyServiceImpl.class);
    @Autowired
    private RSAAutoCertificateConfig rsaAutoCertificateConfig;
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    @Autowired
    private WechatPayProperties wechatPayProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private TIntegralOrderRefundTradeRecordService tIntegralOrderRefundTradeRecordService;
    @Autowired
    private CommonService commonService;

    @Override
    public String wechatPayRefundNotice(HttpServletRequest request) {
        try {
            RefundNotification refundNotification = this.commonService.getNotification(request, RefundNotification.class);
            log.info("wechatPayRefundNotice refundNotification: {}", (Object)JacksonUtil.bean2Json((Object)refundNotification));
            Destination destination = new Destination();
            destination.setTopic("wechat_pay_refund_notice");
            SendResult send = this.rocketMQTemplate.send(destination, (Object)refundNotification);
            log.info("wechatPayRefundNotice send: {}", (Object)JacksonUtil.bean2Json((Object)send));
            return "SUCCESS";
        }
        catch (ValidationException e) {
            log.error("wechatPayRefundNotice sign verification failed", (Throwable)e);
            return "FAIL";
        }
    }

    @Override
    public void wechatPayRefundProcess(RefundNotification refundNotification) {
        log.info("wechatPayRefundProcess refundNotification: {}", (Object)JacksonUtil.bean2Json((Object)refundNotification));
        String outRefundNo = refundNotification.getOutRefundNo();
        ResponseEntity stringResponseEntity = this.restTemplate.postForEntity(this.wechatPayProperties.getOrderNotifyUrl(), (Object)refundNotification, String.class, new Object[0]);
        log.info("wechatPayRefundProcess stringResponseEntity: {}", (Object)JacksonUtil.bean2Json((Object)stringResponseEntity));
        this.tIntegralOrderRefundTradeRecordService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TIntegralOrderRefundTradeRecord::getIntegralRefundOrderTradeRecordCode, (Object)outRefundNo)).set(TIntegralOrderRefundTradeRecord::getState, (Object)refundNotification.getRefundStatus().name())).set(TIntegralOrderRefundTradeRecord::getResultJson, (Object)JacksonUtil.bean2Json((Object)refundNotification)));
    }
}

