/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.payment.api.service.impl;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bizvane.payment.api.config.WechatPayProperties;
import com.bizvane.payment.api.service.CommonService;
import com.bizvane.payment.api.service.MqWechatPayNotifyService;
import com.bizvane.payment.domain.domain.po.TIntegralOrderTradeRecord;
import com.bizvane.payment.domain.service.TIntegralOrderTradeRecordService;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.wechat.pay.java.core.RSAAutoCertificateConfig;
import com.wechat.pay.java.core.exception.ValidationException;
import com.wechat.pay.java.service.partnerpayments.jsapi.model.Transaction;
import javax.servlet.http.HttpServletRequest;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class MqWechatPayNotifyServiceImpl
implements MqWechatPayNotifyService {
    private static final Logger log = LoggerFactory.getLogger(MqWechatPayNotifyServiceImpl.class);
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private RSAAutoCertificateConfig rsaAutoCertificateConfig;
    @Autowired
    private TIntegralOrderTradeRecordService tIntegralOrderTradeRecordService;
    @Autowired
    private WechatPayProperties wechatPayProperties;
    @Autowired
    private CommonService commonService;

    @Override
    public String wechatPayNotice(HttpServletRequest request) {
        try {
            Transaction transaction = this.commonService.getNotification(request, Transaction.class);
            log.info("paySucByCash transaction: {}", (Object)JacksonUtil.bean2Json((Object)transaction));
            Destination destination = new Destination();
            destination.setTopic("wechat_pay_notice");
            SendResult send = this.rocketMQTemplate.send(destination, (Object)transaction);
            log.info("send: {}", (Object)JacksonUtil.bean2Json((Object)send));
            return "SUCCESS";
        }
        catch (ValidationException e) {
            log.error("sign verification failed", (Throwable)e);
            return "FAIL";
        }
    }

    @Override
    public void wechatPayProcess(Transaction transaction) {
        log.info("wechatPayProcess transaction: {}", (Object)JacksonUtil.bean2Json((Object)transaction));
        String outTradeNo = transaction.getOutTradeNo();
        ResponseEntity stringResponseEntity = this.restTemplate.postForEntity(this.wechatPayProperties.getOrderNotifyUrl(), (Object)transaction, String.class, new Object[0]);
        log.info("stringResponseEntity: {}", (Object)JacksonUtil.bean2Json((Object)stringResponseEntity));
        this.tIntegralOrderTradeRecordService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TIntegralOrderTradeRecord::getIntegralMallOrderCode, (Object)outTradeNo)).set(TIntegralOrderTradeRecord::getTradeState, (Object)transaction.getTradeState().name())).set(TIntegralOrderTradeRecord::getTransactionId, (Object)transaction.getTransactionId())).set(TIntegralOrderTradeRecord::getNoticeBodyJson, (Object)JacksonUtil.bean2Json((Object)transaction)));
    }
}

