/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.payment.api.service.impl;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import com.bizvane.payment.api.service.CommonService;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.wechat.pay.java.core.RSAAutoCertificateConfig;
import com.wechat.pay.java.core.notification.NotificationConfig;
import com.wechat.pay.java.core.notification.NotificationParser;
import com.wechat.pay.java.core.notification.RequestParam;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommonServiceImpl
implements CommonService {
    private static final Logger log = LoggerFactory.getLogger(CommonServiceImpl.class);
    @Autowired
    private RSAAutoCertificateConfig rsaAutoCertificateConfig;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T getNotification(HttpServletRequest request, Class<T> clazz) {
        try (ServletInputStream inputStream = request.getInputStream();){
            String body = IoUtil.read((InputStream)inputStream, (Charset)CharsetUtil.CHARSET_UTF_8);
            String wechatSignature = request.getHeader("Wechatpay-Signature");
            String wechatPaySerial = request.getHeader("Wechatpay-Serial");
            String wechatpayNonce = request.getHeader("Wechatpay-Nonce");
            String wechatTimestamp = request.getHeader("Wechatpay-Timestamp");
            RequestParam requestParam = new RequestParam.Builder().serialNumber(wechatPaySerial).nonce(wechatpayNonce).signature(wechatSignature).timestamp(wechatTimestamp).body(body).build();
            NotificationParser parser = new NotificationParser(new NotificationConfig[]{this.rsaAutoCertificateConfig});
            log.info("getNotification requestParam: {}", (Object)JacksonUtil.bean2Json((Object)requestParam));
            Object notification = parser.parse(requestParam, clazz);
            log.info("getNotification notification: {}", (Object)JacksonUtil.bean2Json((Object)notification));
            Object object = notification;
            return (T)object;
        }
        catch (IOException e) {
            log.error("getNotification error: ", (Throwable)e);
            return null;
        }
    }
}

