/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.payment.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bizvane.payment.api.config.WechatPayProperties;
import com.bizvane.payment.api.service.ApiIntegralOrderTradeRecordService;
import com.bizvane.payment.api.service.ApiWechatPayService;
import com.bizvane.payment.api.utils.ResponseUtil;
import com.bizvane.payment.domain.domain.po.TIntegralOrderTradeRecord;
import com.bizvane.payment.domain.service.TIntegralOrderTradeRecordService;
import com.bizvane.payment.feign.vo.req.PrepareOrderReqVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import com.wechat.pay.java.service.payments.jsapi.JsapiServiceExtension;
import com.wechat.pay.java.service.payments.jsapi.model.Amount;
import com.wechat.pay.java.service.payments.jsapi.model.CloseOrderRequest;
import com.wechat.pay.java.service.payments.jsapi.model.Payer;
import com.wechat.pay.java.service.payments.jsapi.model.PrepayRequest;
import com.wechat.pay.java.service.payments.jsapi.model.PrepayWithRequestPaymentResponse;
import com.wechat.pay.java.service.payments.jsapi.model.QueryOrderByOutTradeNoRequest;
import com.wechat.pay.java.service.payments.model.Transaction;
import com.wechat.pay.java.service.refund.RefundService;
import com.wechat.pay.java.service.refund.model.QueryByOutRefundNoRequest;
import com.wechat.pay.java.service.refund.model.Refund;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiWechatPayServiceImpl
implements ApiWechatPayService {
    private static final Logger log = LoggerFactory.getLogger(ApiWechatPayServiceImpl.class);
    @Autowired
    private JsapiServiceExtension jsapiServiceExtension;
    @Autowired
    private RefundService refundService;
    @Autowired
    private WechatPayProperties wechatPayProperties;
    @Autowired
    private TIntegralOrderTradeRecordService tIntegralOrderTradeRecordService;
    @Autowired
    private ApiIntegralOrderTradeRecordService apiIntegralOrderTradeRecordService;

    @Override
    public ResponseData<PrepayWithRequestPaymentResponse> prepareOrder(PrepareOrderReqVO reqVO) {
        PrepayRequest prepayRequest = this.getPrepayRequest(reqVO);
        ResponseData<String> stringResponseData = this.apiIntegralOrderTradeRecordService.saveRecord(prepayRequest);
        log.info("saveRecord: {}", (Object)JacksonUtil.bean2Json(stringResponseData));
        PrepayWithRequestPaymentResponse prepayWithRequestPaymentResponse = this.jsapiServiceExtension.prepayWithRequestPayment(prepayRequest);
        log.info("prepayWithRequestPaymentResponse: {}", (Object)JacksonUtil.bean2Json((Object)prepayWithRequestPaymentResponse));
        return ResponseUtil.getSuccessData(prepayWithRequestPaymentResponse);
    }

    @Override
    public ResponseData<Transaction> queryOrder(String outTradeNo) {
        QueryOrderByOutTradeNoRequest request = new QueryOrderByOutTradeNoRequest();
        request.setOutTradeNo(outTradeNo);
        request.setMchid(this.wechatPayProperties.getMerchantId());
        Transaction transaction = this.jsapiServiceExtension.queryOrderByOutTradeNo(request);
        if (transaction != null) {
            this.tIntegralOrderTradeRecordService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TIntegralOrderTradeRecord::getIntegralMallOrderCode, (Object)outTradeNo)).set(TIntegralOrderTradeRecord::getTradeState, (Object)transaction.getTradeState().name())).set(TIntegralOrderTradeRecord::getTransactionId, (Object)transaction.getTransactionId())).set(TIntegralOrderTradeRecord::getNoticeBodyJson, (Object)JacksonUtil.bean2Json((Object)transaction)));
        }
        return ResponseUtil.getSuccessData(transaction);
    }

    @Override
    public ResponseData<Boolean> closeOrder(String outTradeNo) {
        CloseOrderRequest request = new CloseOrderRequest();
        request.setMchid(this.wechatPayProperties.getMerchantId());
        request.setOutTradeNo(outTradeNo);
        this.jsapiServiceExtension.closeOrder(request);
        return ResponseUtil.getSuccessData(true);
    }

    @Override
    public ResponseData<Refund> queryRefundOrder(String outRefundNo) {
        QueryByOutRefundNoRequest request = new QueryByOutRefundNoRequest();
        request.setOutRefundNo(outRefundNo);
        Refund refund = this.refundService.queryByOutRefundNo(request);
        log.info("refund: {}", (Object)JacksonUtil.bean2Json((Object)refund));
        return ResponseUtil.getSuccessData(refund);
    }

    private PrepayRequest getPrepayRequest(PrepareOrderReqVO reqVO) {
        PrepayRequest prepayRequest = new PrepayRequest();
        prepayRequest.setAppid(this.wechatPayProperties.getAppId());
        prepayRequest.setMchid(this.wechatPayProperties.getMerchantId());
        prepayRequest.setNotifyUrl(this.wechatPayProperties.getWechatPayNotifyUrl());
        prepayRequest.setDescription(reqVO.getDescription());
        Amount amount = new Amount();
        amount.setTotal(reqVO.getAmount());
        amount.setCurrency("CNY");
        prepayRequest.setAmount(amount);
        Payer payer = new Payer();
        payer.setOpenid(reqVO.getOpenid());
        prepayRequest.setPayer(payer);
        return prepayRequest;
    }
}

