/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.payment.api.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.bizvane.payment.api.config.WechatPayProperties;
import com.bizvane.payment.api.controller.req.RefundOrderReqVO;
import com.bizvane.payment.api.service.ApiIntegralOrderRefundTradeRecordService;
import com.bizvane.payment.api.utils.ResponseUtil;
import com.bizvane.payment.domain.domain.po.TIntegralOrderRefundTradeRecord;
import com.bizvane.payment.domain.service.TIntegralOrderRefundTradeRecordService;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import com.wechat.pay.java.service.refund.RefundService;
import com.wechat.pay.java.service.refund.model.AmountReq;
import com.wechat.pay.java.service.refund.model.CreateRequest;
import com.wechat.pay.java.service.refund.model.Refund;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiIntegralOrderRefundTradeRecordServiceImpl
implements ApiIntegralOrderRefundTradeRecordService {
    private static final Logger log = LoggerFactory.getLogger(ApiIntegralOrderRefundTradeRecordServiceImpl.class);
    @Autowired
    private RefundService refundService;
    @Autowired
    private WechatPayProperties wechatPayProperties;
    @Autowired
    private TIntegralOrderRefundTradeRecordService tIntegralOrderRefundTradeRecordService;

    @Override
    public ResponseData<String> refundOrder(RefundOrderReqVO reqVO) {
        CreateRequest createRequest = this.getCreateRequest(reqVO);
        TIntegralOrderRefundTradeRecord refundTradeRecord = new TIntegralOrderRefundTradeRecord();
        refundTradeRecord.setIntegralOrderCode(reqVO.getIntegralOrderCode());
        refundTradeRecord.setIntegralRefundOrderCode(reqVO.getIntegralRefundOrderCode());
        refundTradeRecord.setIntegralRefundOrderTradeRecordCode(IdUtil.simpleUUID());
        refundTradeRecord.setBodyJson(JacksonUtil.bean2Json((Object)createRequest));
        this.tIntegralOrderRefundTradeRecordService.save((Object)refundTradeRecord);
        Refund refund = this.refundService.create(createRequest);
        log.info("refundOrder refund: {}", (Object)JacksonUtil.bean2Json((Object)refund));
        if (refund == null) {
            return ResponseUtil.getFailedMsg("\u9000\u6b3e\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        refundTradeRecord.setRefundId(refund.getRefundId());
        refundTradeRecord.setTransactionId(refund.getTransactionId());
        refundTradeRecord.setState(refund.getStatus() != null ? refund.getStatus().name() : null);
        refundTradeRecord.setSuccessTime(StrUtil.isNotBlank((CharSequence)refund.getSuccessTime()) ? DateUtil.parse((CharSequence)refund.getSuccessTime()) : null);
        this.tIntegralOrderRefundTradeRecordService.updateById((Object)refundTradeRecord);
        return ResponseUtil.getSuccessData("\u64cd\u4f5c\u6210\u529f");
    }

    private CreateRequest getCreateRequest(RefundOrderReqVO reqVO) {
        CreateRequest createRequest = new CreateRequest();
        createRequest.setOutRefundNo(reqVO.getIntegralRefundOrderCode());
        createRequest.setNotifyUrl(this.wechatPayProperties.getWechatPayRefundNotifyUrl());
        AmountReq amountReq = new AmountReq();
        amountReq.setRefund(Long.valueOf(reqVO.getRefundAmount().intValue()));
        amountReq.setTotal(Long.valueOf(reqVO.getOrderAmount().intValue()));
        amountReq.setCurrency("CNY");
        createRequest.setAmount(amountReq);
        createRequest.setReason(reqVO.getRefundReason());
        return createRequest;
    }
}

