/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.base.common.bean;

public enum PayStrategyEnum {
    WEIXIN_PAY_STRATEGY("\u5fae\u4fe1\u652f\u4ed8", "WX_PAY_STRATEGY", "JSAPI", "WEIXIN_TYPE", false, false),
    UNION_PAY_STRATEGY("\u5fae\u4fe1\u94f6\u8054\u652f\u4ed8", "UNION_PAY_STRATEGY", "JSAPI", "UNION_TYPE", false, false),
    ALI_ISV_PAY_STRATEGY("ALI_ISV\u652f\u4ed8", "ALI_ISV_PAY_STRATEGY", "JSAPI", "ALI_ISV_TYPE", true, true),
    ALI_PAY_STRATEGY("ALI_\u652f\u4ed8", "ALI_PAY_STRATEGY", "JSAPI", "ALI_TYPE", false, false);

    private String name;
    private String key;
    private String type;
    private String payType;
    private Boolean needThirdToken;
    private Boolean needPrivateKey;

    private PayStrategyEnum(String name, String key, String type, String payType, Boolean needThirdToken, Boolean needPrivateKey) {
        this.name = name;
        this.key = key;
        this.type = type;
        this.payType = payType;
        this.needThirdToken = needThirdToken;
        this.needPrivateKey = needPrivateKey;
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public String getType() {
        return this.type;
    }

    public String getPayType() {
        return this.payType;
    }

    public static String getStrategyByPayType(String payType) {
        PayStrategyEnum[] values;
        for (PayStrategyEnum value : values = PayStrategyEnum.values()) {
            if (!value.getPayType().equals(payType)) continue;
            return value.getKey();
        }
        return null;
    }

    public static Boolean isNeedThirdToken(String payType) {
        PayStrategyEnum[] values;
        for (PayStrategyEnum value : values = PayStrategyEnum.values()) {
            if (!payType.equals(value.getPayType())) continue;
            return value.needThirdToken;
        }
        return false;
    }

    public static Boolean isNeedPrivateKey(String payType) {
        PayStrategyEnum[] values;
        for (PayStrategyEnum value : values = PayStrategyEnum.values()) {
            if (!payType.equals(value.getPayType())) continue;
            return value.needPrivateKey;
        }
        return false;
    }
}

