/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.gateway2.webfilter;

import brave.Span;
import com.bizvane.openapi.common.response.ResponseProperties;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class ReactiveAddTraceIdFilter
implements WebFilter {
    private ResponseProperties properties;

    public ReactiveAddTraceIdFilter(ResponseProperties properties) {
        this.properties = properties;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        Span span = (Span)exchange.getAttribute("org.springframework.cloud.sleuth.instrument.web.TraceWebFilter.TRACE");
        if (span != null && span.context() != null) {
            String traceId = span.context().traceIdString();
            exchange.getResponse().getHeaders().add(this.properties.getId(), traceId);
        }
        return chain.filter(exchange);
    }
}

