/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.gateway2.route;

import com.bizvane.openapi.gateway2.config.SkipSignatureValidationProperties;
import com.bizvane.openapi.gateway2.filter.CheckAccessTokenGatewayFilterFactory;
import com.bizvane.openapi.gateway2.filter.CheckReplayAttackGatewayFilterFactory;
import com.bizvane.openapi.gateway2.filter.CheckRequiredHeadersGatewayFilterFactory;
import com.bizvane.openapi.gateway2.filter.CheckSignatureGatewayFilterFactory;
import com.bizvane.openapi.gateway2.filter.CheckTimestampGatewayFilterFactory;
import com.bizvane.openapi.gateway2.filter.LogRequestBodyGatewayFilterFactory;
import com.bizvane.openapi.gateway2.filter.ModifyRequestGatewayFilterFactory;
import com.bizvane.openapi.gateway2.filter.SkipSignatureValidationGatewayFilterFactory;
import com.bizvane.openapi.gateway2.module.service.service.ServiceManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.event.RefreshRoutesEvent;
import org.springframework.cloud.gateway.filter.factory.SetPathGatewayFilterFactory;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

public class DynamicRouteLocator
implements RouteLocator,
ApplicationEventPublisherAware {
    private static final Logger log = LoggerFactory.getLogger(DynamicRouteLocator.class);
    private ApplicationEventPublisher publisher;
    @Autowired
    RouteLocatorBuilder builder;
    @Autowired
    ServiceManager serviceManager;
    @Autowired
    SetPathGatewayFilterFactory setPathGatewayFilterFactory;
    @Autowired
    LogRequestBodyGatewayFilterFactory logRequestBodyGatewayFilterFactory;
    @Autowired
    CheckRequiredHeadersGatewayFilterFactory checkRequiredHeadersGatewayFilterFactory;
    @Autowired
    CheckTimestampGatewayFilterFactory checkTimestampGatewayFilterFactory;
    @Autowired
    CheckAccessTokenGatewayFilterFactory checkAccessTokenGatewayFilterFactory;
    @Autowired
    CheckReplayAttackGatewayFilterFactory checkReplayAttackGatewayFilterFactory;
    @Autowired
    CheckSignatureGatewayFilterFactory checkSignatureGatewayFilterFactory;
    @Autowired
    ModifyRequestGatewayFilterFactory modifyRequestGatewayFilterFactory;
    @Autowired
    SkipSignatureValidationGatewayFilterFactory skipSignatureValidationGatewayFilterFactory;
    @Autowired
    SkipSignatureValidationProperties skipSignatureValidationProperties;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    @Scheduled(initialDelay=60000L, fixedDelay=60000L)
    public void refresh() {
        log.info("refresh~~~~");
        this.publisher.publishEvent((ApplicationEvent)new RefreshRoutesEvent((Object)this));
    }

    public Flux<Route> getRoutes() {
        RouteLocatorBuilder.Builder routes = this.builder.routes();
        this.serviceManager.listService().forEach(service -> {
            AtomicReference<String> businessIdRef = new AtomicReference<String>();
            AtomicReference<Boolean> enabledRef = new AtomicReference<Boolean>();
            Map services = this.skipSignatureValidationProperties.getServices();
            if (services != null && services.get(service.getAlias()) != null) {
                businessIdRef.set(((SkipSignatureValidationProperties.ServiceProperties)services.get(service.getAlias())).getBusinessId());
                enabledRef.set(((SkipSignatureValidationProperties.ServiceProperties)services.get(service.getAlias())).isEnabled());
            }
            this.serviceManager.listApiInfo(service.getId()).forEach(api -> {
                try {
                    URI uri = new URI(api.getUrl());
                    SetPathGatewayFilterFactory.Config config = new SetPathGatewayFilterFactory.Config();
                    config.setTemplate(uri.getPath());
                    routes.route(String.format("%s::%s", service.getAlias(), api.getAlias()), r -> r.path(new String[]{String.format("/request/%s/%s", service.getAlias(), api.getAlias())}).and().readBody(Map.class, requestBody -> true).filters(f -> {
                        f.filter(this.setPathGatewayFilterFactory.apply(config));
                        f.filter(this.logRequestBodyGatewayFilterFactory.apply(new Object()));
                        if (StringUtils.hasText((String)((String)businessIdRef.get())) && enabledRef.get() != null && ((Boolean)enabledRef.get()).equals(true)) {
                            f.filter(this.checkTimestampGatewayFilterFactory.apply(new Object()));
                            f.filter(this.skipSignatureValidationGatewayFilterFactory.apply(new SkipSignatureValidationGatewayFilterFactory.Config((String)businessIdRef.get())));
                        } else {
                            f.filter(this.checkRequiredHeadersGatewayFilterFactory.apply(new Object()));
                            f.filter(this.checkTimestampGatewayFilterFactory.apply(new Object()));
                            f.filter(this.checkAccessTokenGatewayFilterFactory.apply(new Object()));
                            f.filter(this.checkReplayAttackGatewayFilterFactory.apply(new Object()));
                            f.filter(this.checkSignatureGatewayFilterFactory.apply(new Object()));
                        }
                        f.filter(this.modifyRequestGatewayFilterFactory.apply(new Object()));
                        return f;
                    }).uri(uri));
                }
                catch (URISyntaxException e) {
                    log.error("URI\u5f02\u5e38", (Throwable)e);
                }
            });
        });
        return routes.build().getRoutes();
    }
}

