/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.gateway2.module.token.service.impl;

import com.bizvane.openapi.authentication.AuthenticationService;
import com.bizvane.openapi.authentication.vo.Client;
import com.bizvane.openapi.authentication.vo.Token;
import com.bizvane.openapi.common.utils.SignatureUtils;
import com.bizvane.openapi.gateway2.module.cache.GatewayManager;
import com.bizvane.openapi.gateway2.module.token.service.OauthManager;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OauthManagerImpl
implements OauthManager {
    @Autowired
    AuthenticationService authenticationService;
    @Autowired
    GatewayManager gatewayManager;

    public Token accessToken(String appKey, String appSecret) {
        Client client = this.gatewayManager.getClient(appKey, appSecret);
        Token accessToken = this.authenticationService.accessToken(client);
        return accessToken;
    }

    public Token refreshToken(String appKey, String refreshToken) {
        Token accessToken = this.authenticationService.refreshToken(appKey, refreshToken);
        return accessToken;
    }

    public boolean verifySignature(String sign, String accessToken, Map<String, Object> params) {
        boolean verifySignature = this.authenticationService.verifySignature(sign, accessToken, params);
        return verifySignature;
    }

    public String signatureWithAppKey(String appKey, Map<String, Object> params) {
        return this.authenticationService.signature(appKey, params);
    }

    public String signatureWithAppSecret(String appSecret, Map<String, Object> params) {
        return SignatureUtils.sign((String)appSecret, params);
    }

    public Client getClient(String accessToken) {
        return this.authenticationService.getClient(accessToken);
    }
}

