/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.gateway2.module.token.controller;

import com.alibaba.fastjson.JSON;
import com.bizvane.openapi.gateway2.module.token.service.OauthManager;
import com.bizvane.openapi.gateway2.module.token.vo.AccessTokenVO;
import com.bizvane.openapi.gateway2.module.token.vo.RefreshTokenVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/oauth2"})
@Api(tags={"\u4ee4\u724c"})
public class OauthController {
    private static final Logger log = LoggerFactory.getLogger(OauthController.class);
    @Autowired
    OauthManager oauthManager;

    @ApiOperation(value="\u83b7\u53d6token")
    @PostMapping(value={"/accessToken"})
    public Mono<Object> getToken(@RequestBody AccessTokenVO vo) {
        log.info("accessToken:param:{}", JSON.toJSON((Object)vo));
        Mono result = Mono.just((Object)this.oauthManager.accessToken(vo.getAppKey(), vo.getAppSecret()));
        log.info("accessToken:result:{}", JSON.toJSON((Object)result));
        return result;
    }

    @ApiOperation(value="\u5237\u65b0token")
    @PostMapping(value={"/refreshToken"})
    public Mono<Object> refreshToken(@RequestBody RefreshTokenVO vo) {
        log.info("refreshToken:param:{}", JSON.toJSON((Object)vo));
        Mono result = Mono.just((Object)this.oauthManager.refreshToken(vo.getAppKey(), vo.getRefreshToken()));
        log.info("refreshToken:result:{}", JSON.toJSON((Object)result));
        return result;
    }
}

