/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.gateway2.module.request.service.impl;

import brave.Tracer;
import com.bizvane.openapi.authentication.vo.Client;
import com.bizvane.openapi.business.modules.cache.vo.ServiceApiVO;
import com.bizvane.openapi.common.exception.OpenApiException;
import com.bizvane.openapi.common.exception.OpenApiExceptionSupplier;
import com.bizvane.openapi.common.response.CodeMessage;
import com.bizvane.openapi.common.utils.Assert;
import com.bizvane.openapi.gateway2.consts.CodeMessageConsts;
import com.bizvane.openapi.gateway2.module.cache.GatewayManager;
import com.bizvane.openapi.gateway2.module.request.service.RequestManager;
import com.bizvane.openapi.gateway2.module.token.service.OauthManager;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;

@Service
public class RequestManagerImpl
implements RequestManager {
    @Value(value="${bizvane.openapi.gateway.reject-timeout:900000}")
    private long rejectTimeout;
    @Autowired
    OauthManager oauthManager;
    @Autowired
    CacheManager cacheManager;
    @Autowired
    GatewayManager gatewayManager;
    @Autowired
    Tracer tracer;
    @Value(value="${spring.application.name}")
    String appName;
    static Set<String> signatureHeaders = Sets.newHashSet((Object[])new String[]{"bizvane-appkey", "bizvane-timestamp", "bizvane-nonce"});
    static String signatureHeadersValue = Joiner.on((char)',').join((Iterable)signatureHeaders);

    public Object request(String currentPath, String serviceAlias, String apiAlias, Map<String, String> headers, Map<String, Object> body) {
        AtomicReference businessIdRef = new AtomicReference();
        String appKey = Strings.emptyToNull((String)headers.get("bizvane-appkey"));
        Optional.ofNullable(appKey).map(arg_0 -> ((GatewayManager)this.gatewayManager).getClient(arg_0)).map(Client::getExt).ifPresent(ext -> Optional.ofNullable(ext.get("business_id")).ifPresent(businessIdRef::set));
        String timestampStr = Optional.ofNullable(Strings.emptyToNull((String)headers.get("bizvane-timestamp"))).orElseThrow(OpenApiExceptionSupplier.convert((CodeMessage)CodeMessageConsts.Gateway.TIMESTAMP_EMPTY));
        String accessToken = Optional.ofNullable(Strings.emptyToNull((String)headers.get("bizvane-access-token"))).orElseThrow(OpenApiExceptionSupplier.convert((CodeMessage)CodeMessageConsts.Gateway.ACCESS_TOKEN_EMPTY));
        String nonce = Optional.ofNullable(Strings.emptyToNull((String)headers.get("bizvane-nonce"))).orElseThrow(OpenApiExceptionSupplier.convert((CodeMessage)CodeMessageConsts.Gateway.NONCE_EMPTY));
        String signature = Optional.ofNullable(Strings.emptyToNull((String)headers.get("bizvane-signature"))).orElseThrow(OpenApiExceptionSupplier.convert((CodeMessage)CodeMessageConsts.Gateway.SIGNATURE_EMPTY));
        long timestamp = this.checkTimestamp(timestampStr);
        Client client = this.checkAccessToken(accessToken);
        Optional.of(client).map(Client::getExt).ifPresent(ext -> Optional.ofNullable(ext.get("business_id")).ifPresent(businessIdRef::set));
        this.checkReplayAttack(currentPath, accessToken, nonce);
        this.checkSignature(body, accessToken, timestamp, nonce, signature);
        ServiceApiVO serviceApiVO = this.checkServiceApi(serviceAlias, apiAlias);
        return null;
    }

    private Client checkAccessToken(String accessToken) {
        return Optional.ofNullable(this.oauthManager.getClient(accessToken)).orElseThrow(OpenApiExceptionSupplier.convert((CodeMessage)CodeMessageConsts.Gateway.INVALID_ACCESS_TOKEN));
    }

    private long checkTimestamp(String timestampStr) {
        long timestamp;
        try {
            timestamp = Long.parseLong(timestampStr);
        }
        catch (NumberFormatException e) {
            throw new OpenApiException(CodeMessageConsts.Gateway.INVALID_TIMESTAMP);
        }
        Assert.isTrue((System.currentTimeMillis() - timestamp <= this.rejectTimeout ? 1 : 0) != 0, (CodeMessage)CodeMessageConsts.Gateway.INVALID_TIMESTAMP);
        return timestamp;
    }

    private void checkReplayAttack(String currentPath, String accessToken, String nonce) {
        Cache pathCache = this.cacheManager.getCache("request_path");
        String path = Strings.lenientFormat((String)"%s-%s-%s", (Object[])new Object[]{accessToken, nonce, currentPath});
        Boolean replay = (Boolean)pathCache.get((Object)path, Boolean.class);
        Assert.isNull((Object)replay, (CodeMessage)CodeMessageConsts.Gateway.NONCE_USED);
        pathCache.put((Object)path, (Object)Boolean.TRUE);
    }

    private void checkSignature(Map<String, Object> body, String accessToken, long timestamp, String nonce, String signatrue) {
        body = Optional.ofNullable(body).orElseGet(() -> Maps.newHashMapWithExpectedSize((int)4));
        body.put("bizvane-timestamp", timestamp);
        body.put("bizvane-nonce", nonce);
        body.put("bizvane-access-token", accessToken);
        boolean verifySignature = this.oauthManager.verifySignature(signatrue, accessToken, body);
        Assert.isTrue((boolean)verifySignature, (CodeMessage)CodeMessageConsts.Gateway.SIGNATURE_DOES_NOT_MATCH);
    }

    private ServiceApiVO checkServiceApi(String serviceAlias, String apiAlias) {
        return this.gatewayManager.getServiceApi(serviceAlias, apiAlias);
    }
}

