/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.gateway2.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bizvane.openapi.business.modules.cache.vo.ServiceApiParamsVO;
import com.bizvane.openapi.business.modules.cache.vo.ServiceApiVO;
import com.bizvane.openapi.common.exception.OpenApiException;
import com.bizvane.openapi.common.response.CodeMessage;
import com.bizvane.openapi.gateway2.filter.rewrite.MyCachedBodyOutputMessage;
import com.bizvane.openapi.gateway2.module.cache.GatewayManager;
import com.bizvane.openapi.gateway2.module.request.vo.RequestVO;
import com.bizvane.openapi.gateway2.module.token.service.OauthManager;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.BodyInserterContext;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ModifyRequestGatewayFilterFactory
extends AbstractGatewayFilterFactory<Object> {
    private static final Logger log = LoggerFactory.getLogger(ModifyRequestGatewayFilterFactory.class);
    @Autowired
    GatewayManager gatewayManager;
    @Autowired
    OauthManager oauthManager;
    static final ParserConfig JSON_CONFIG = new ParserConfig();
    static Set<String> signatureHeaders;
    static String signatureHeadersValue;

    public GatewayFilter apply(Object config) {
        return (exchange, chain) -> {
            if (!exchange.getRequest().getMethod().equals((Object)HttpMethod.POST)) {
                throw OpenApiException.newInstance((CodeMessage)CodeMessage.newClientInstance((String)"\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u65b9\u5f0f"));
            }
            Route route = (Route)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR);
            String routeId = route.getId();
            String[] split = routeId.split("::");
            if (split.length != 2) {
                throw OpenApiException.newInstance((CodeMessage)CodeMessage.newServerInstance((String)"RouteID.Error"));
            }
            String serviceAlias = split[0];
            String apiAlias = split[1];
            ServiceApiVO serviceApiVO = this.checkServiceApi(serviceAlias, apiAlias);
            Map cachedRequestBodyObject = (Map)exchange.getAttribute("cachedRequestBodyObject");
            String requestBody = JSON.toJSONString((Object)cachedRequestBodyObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.MapSortField});
            JSONObject jsonObject = (JSONObject)JSON.parseObject((String)requestBody, JSONObject.class, (ParserConfig)JSON_CONFIG, (Feature[])new Feature[]{Feature.CustomMapDeserializer});
            RequestVO requestVO = this.buildRequestParams(serviceApiVO.getRequestParams(), (Map)jsonObject);
            this.secondSignature(requestVO, serviceApiVO.getAppKey(), serviceApiVO.getAppSecret(), exchange.getAttribute("business_id"));
            HttpHeaders headers = new HttpHeaders();
            headers.putAll((Map)exchange.getRequest().getHeaders());
            headers.putAll(requestVO.getHeadersMap());
            headers.remove((Object)"Content-Length");
            BodyInserter bodyInserter = BodyInserters.fromObject((Object)requestVO.getBodyMap());
            MyCachedBodyOutputMessage outputMessage = new MyCachedBodyOutputMessage(exchange, headers);
            return bodyInserter.insert((ReactiveHttpOutputMessage)outputMessage, (BodyInserter.Context)new BodyInserterContext()).then(Mono.defer(() -> {
                ServerHttpRequestDecorator decorator = this.decorate(exchange, headers, outputMessage);
                return chain.filter(exchange.mutate().request((ServerHttpRequest)decorator).build());
            }));
        };
    }

    private ServiceApiVO checkServiceApi(String serviceAlias, String apiAlias) {
        return this.gatewayManager.getServiceApi(serviceAlias, apiAlias);
    }

    private RequestVO buildRequestParams(List<ServiceApiParamsVO> requestParams, Map<String, Object> body) {
        RequestVO vo = new RequestVO();
        if (!CollectionUtils.isEmpty(requestParams)) {
            block10: for (ServiceApiParamsVO params : requestParams) {
                String key = params.getParamName();
                Object val = body.get(key);
                switch (params.getRequestType()) {
                    case "header": {
                        vo.getHeadersMap().put(key, Lists.newArrayList((Object[])new String[]{String.valueOf(val)}));
                        continue block10;
                    }
                    case "path": {
                        continue block10;
                    }
                    case "body": {
                        vo.getBodyMap().put(key, val);
                        continue block10;
                    }
                }
                vo.getParamsMap().put(key, val);
            }
        }
        return vo;
    }

    private void secondSignature(RequestVO requestVO, String providerAppKey, String providerAppSecret, Object requestBusinessId) {
        HashMap signatureHeadersMap = Maps.newHashMap();
        String nonce = RandomStringUtils.randomAlphabetic((int)8);
        String timestamp = String.valueOf(System.currentTimeMillis());
        String appKey = providerAppKey;
        signatureHeadersMap.put("bizvane-nonce", nonce);
        signatureHeadersMap.put("bizvane-timestamp", timestamp);
        signatureHeadersMap.put("bizvane-appkey", appKey);
        HashMap params = Maps.newHashMap();
        params.putAll(requestVO.getParamsMap());
        params.putAll(requestVO.getBodyMap());
        params.putAll(signatureHeadersMap);
        String signatureWithAppSecret = this.oauthManager.signatureWithAppSecret(providerAppSecret, (Map)params);
        HashMap headersMap = Maps.newHashMap();
        headersMap.put("bizvane-nonce", Lists.newArrayList((Object[])new String[]{nonce}));
        headersMap.put("bizvane-timestamp", Lists.newArrayList((Object[])new String[]{timestamp}));
        headersMap.put("bizvane-appkey", Lists.newArrayList((Object[])new String[]{appKey}));
        headersMap.put("bizvane-signature-headers", Lists.newArrayList((Object[])new String[]{signatureHeadersValue}));
        headersMap.put("bizvane-request-business-id", Lists.newArrayList((Object[])new String[]{String.valueOf(requestBusinessId)}));
        headersMap.put("bizvane-signature", Lists.newArrayList((Object[])new String[]{signatureWithAppSecret}));
        requestVO.getHeadersMap().putAll(headersMap);
    }

    ServerHttpRequestDecorator decorate(ServerWebExchange exchange, HttpHeaders headers, MyCachedBodyOutputMessage outputMessage) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static {
        JSON_CONFIG.getDeserializers().put(Map.class, (Object)new /* Unavailable Anonymous Inner Class!! */);
        signatureHeaders = Sets.newHashSet((Object[])new String[]{"bizvane-appkey", "bizvane-timestamp", "bizvane-nonce"});
        signatureHeadersValue = Joiner.on((char)',').join((Iterable)signatureHeaders);
    }
}

