/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.gateway2.filter;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.web.reactive.function.server.HandlerStrategies;

public class LogRequestBodyGatewayFilterFactory
extends AbstractGatewayFilterFactory<Object> {
    private static final Logger log = LoggerFactory.getLogger(LogRequestBodyGatewayFilterFactory.class);
    private static final List<HttpMessageReader<?>> MESSAGE_READERS = HandlerStrategies.withDefaults().messageReaders();

    public GatewayFilter apply(Object config) {
        return (exchange, chain) -> {
            Object cachedRequestBodyObject = exchange.getAttribute("cachedRequestBodyObject");
            HttpHeaders headers = exchange.getRequest().getHeaders();
            HashMap headersMap = Maps.newHashMap();
            headersMap.put("bizvane-timestamp", headers.getFirst("bizvane-timestamp"));
            headersMap.put("bizvane-access-token", headers.getFirst("bizvane-access-token"));
            headersMap.put("bizvane-appkey", headers.getFirst("bizvane-appkey"));
            headersMap.put("bizvane-nonce", headers.getFirst("bizvane-nonce"));
            headersMap.put("bizvane-signature", headers.getFirst("bizvane-signature"));
            log.info("{} | {} | headers: {} | body: {}", new Object[]{JSON.toJSONString((Object)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_ORIGINAL_REQUEST_URL_ATTR)), exchange.getRequest().getPath(), JSON.toJSONString((Object)headersMap), JSON.toJSONString((Object)cachedRequestBodyObject)});
            return chain.filter(exchange);
        };
    }
}

