/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.gateway2.filter;

import com.bizvane.openapi.common.exception.OpenApiException;
import com.bizvane.openapi.common.exception.OpenApiExceptionSupplier;
import com.bizvane.openapi.common.response.CodeMessage;
import com.bizvane.openapi.common.utils.Assert;
import com.bizvane.openapi.gateway2.consts.CodeMessageConsts;
import com.google.common.base.Strings;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;

public class CheckTimestampGatewayFilterFactory
extends AbstractGatewayFilterFactory<Object> {
    @Value(value="${bizvane.openapi.gateway.reject-timeout:900000}")
    private long rejectTimeout;

    public GatewayFilter apply(Object config) {
        return (exchange, chain) -> {
            String timestamp = Optional.ofNullable(Strings.emptyToNull((String)exchange.getRequest().getHeaders().getFirst("bizvane-timestamp"))).orElseThrow(OpenApiExceptionSupplier.convert((CodeMessage)CodeMessageConsts.Gateway.TIMESTAMP_EMPTY));
            this.checkTimestamp(timestamp);
            return chain.filter(exchange);
        };
    }

    private long checkTimestamp(String timestampStr) {
        long timestamp;
        try {
            timestamp = Long.parseLong(timestampStr);
        }
        catch (NumberFormatException e) {
            throw new OpenApiException(CodeMessageConsts.Gateway.INVALID_TIMESTAMP);
        }
        Assert.isTrue((System.currentTimeMillis() - timestamp <= this.rejectTimeout ? 1 : 0) != 0, (CodeMessage)CodeMessageConsts.Gateway.INVALID_TIMESTAMP);
        return timestamp;
    }
}

