/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.gateway2.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bizvane.openapi.common.response.CodeMessage;
import com.bizvane.openapi.common.utils.Assert;
import com.bizvane.openapi.gateway2.consts.CodeMessageConsts;
import com.bizvane.openapi.gateway2.module.token.service.OauthManager;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;

public class CheckSignatureGatewayFilterFactory
extends AbstractGatewayFilterFactory<Object> {
    @Autowired
    OauthManager oauthManager;
    static final ParserConfig JSON_CONFIG = new ParserConfig();

    public GatewayFilter apply(Object config) {
        return (exchange, chain) -> {
            String signature = (String)exchange.getAttribute("bizvane-signature");
            String accessToken = (String)exchange.getAttribute("bizvane-access-token");
            String timestamp = (String)exchange.getAttribute("bizvane-timestamp");
            String nonce = (String)exchange.getAttribute("bizvane-nonce");
            Map cachedRequestBodyObject = (Map)exchange.getAttribute("cachedRequestBodyObject");
            String requestBody = JSON.toJSONString((Object)cachedRequestBodyObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.MapSortField});
            JSONObject jsonObject = (JSONObject)JSON.parseObject((String)requestBody, JSONObject.class, (ParserConfig)JSON_CONFIG, (Feature[])new Feature[]{Feature.CustomMapDeserializer});
            this.checkSignature((Map)jsonObject, accessToken, timestamp, nonce, signature);
            return chain.filter(exchange);
        };
    }

    private void checkSignature(Map<String, Object> body, String accessToken, String timestamp, String nonce, String signatrue) {
        body = Optional.ofNullable(body).orElseGet(() -> Maps.newHashMapWithExpectedSize((int)4));
        body.put("bizvane-timestamp", timestamp);
        body.put("bizvane-nonce", nonce);
        body.put("bizvane-access-token", accessToken);
        boolean verifySignature = this.oauthManager.verifySignature(signatrue, accessToken, body);
        Assert.isTrue((boolean)verifySignature, (CodeMessage)CodeMessageConsts.Gateway.SIGNATURE_DOES_NOT_MATCH);
    }

    static {
        JSON_CONFIG.getDeserializers().put(Map.class, (Object)new /* Unavailable Anonymous Inner Class!! */);
    }
}

