/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.gateway2.filter;

import com.bizvane.openapi.common.exception.OpenApiExceptionSupplier;
import com.bizvane.openapi.common.response.CodeMessage;
import com.bizvane.openapi.gateway2.consts.CodeMessageConsts;
import com.google.common.base.Strings;
import java.util.Optional;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.http.HttpHeaders;

public class CheckRequiredHeadersGatewayFilterFactory
extends AbstractGatewayFilterFactory<Object> {
    public GatewayFilter apply(Object config) {
        return (exchange, chain) -> {
            HttpHeaders headers = exchange.getRequest().getHeaders();
            String timestamp = Optional.ofNullable(Strings.emptyToNull((String)headers.getFirst("bizvane-timestamp"))).orElseThrow(OpenApiExceptionSupplier.convert((CodeMessage)CodeMessageConsts.Gateway.TIMESTAMP_EMPTY));
            String accessToken = Optional.ofNullable(Strings.emptyToNull((String)headers.getFirst("bizvane-access-token"))).orElseThrow(OpenApiExceptionSupplier.convert((CodeMessage)CodeMessageConsts.Gateway.ACCESS_TOKEN_EMPTY));
            String nonce = Optional.ofNullable(Strings.emptyToNull((String)headers.getFirst("bizvane-nonce"))).orElseThrow(OpenApiExceptionSupplier.convert((CodeMessage)CodeMessageConsts.Gateway.NONCE_EMPTY));
            String signature = Optional.ofNullable(Strings.emptyToNull((String)headers.getFirst("bizvane-signature"))).orElseThrow(OpenApiExceptionSupplier.convert((CodeMessage)CodeMessageConsts.Gateway.SIGNATURE_EMPTY));
            exchange.getAttributes().put("bizvane-timestamp", timestamp);
            exchange.getAttributes().put("bizvane-access-token", accessToken);
            exchange.getAttributes().put("bizvane-nonce", nonce);
            exchange.getAttributes().put("bizvane-signature", signature);
            return chain.filter(exchange);
        };
    }
}

