/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.gateway2.filter;

import com.bizvane.openapi.common.exception.OpenApiExceptionSupplier;
import com.bizvane.openapi.common.response.CodeMessage;
import com.bizvane.openapi.common.utils.Assert;
import com.bizvane.openapi.gateway2.consts.CodeMessageConsts;
import com.google.common.base.Strings;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;

public class CheckReplayAttackGatewayFilterFactory
extends AbstractGatewayFilterFactory<Object> {
    @Autowired
    CacheManager cacheManager;

    public GatewayFilter apply(Object config) {
        return (exchange, chain) -> {
            Object requestUrl = exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_ORIGINAL_REQUEST_URL_ATTR);
            String accessToken = Optional.ofNullable(Strings.emptyToNull((String)((String)exchange.getAttribute("bizvane-access-token")))).orElseThrow(OpenApiExceptionSupplier.convert((CodeMessage)CodeMessageConsts.Gateway.ACCESS_TOKEN_EMPTY));
            String nonce = Optional.ofNullable(Strings.emptyToNull((String)((String)exchange.getAttribute("bizvane-nonce")))).orElseThrow(OpenApiExceptionSupplier.convert((CodeMessage)CodeMessageConsts.Gateway.NONCE_EMPTY));
            this.checkReplayAttack(String.valueOf(requestUrl), String.valueOf(accessToken), nonce);
            return chain.filter(exchange);
        };
    }

    private void checkReplayAttack(String currentPath, String accessToken, String nonce) {
        Cache pathCache = this.cacheManager.getCache("request_path");
        String path = Strings.lenientFormat((String)"%s-%s-%s", (Object[])new Object[]{accessToken, nonce, currentPath});
        Boolean replay = (Boolean)pathCache.get((Object)path, Boolean.class);
        Assert.isNull((Object)replay, (CodeMessage)CodeMessageConsts.Gateway.NONCE_USED);
        pathCache.put((Object)path, (Object)Boolean.TRUE);
    }
}

