/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.gateway2.filter;

import com.bizvane.openapi.authentication.vo.Client;
import com.bizvane.openapi.common.exception.OpenApiExceptionSupplier;
import com.bizvane.openapi.common.response.CodeMessage;
import com.bizvane.openapi.gateway2.consts.CodeMessageConsts;
import com.bizvane.openapi.gateway2.module.token.service.OauthManager;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;

public class CheckAccessTokenGatewayFilterFactory
extends AbstractGatewayFilterFactory<Object> {
    @Autowired
    OauthManager oauthManager;

    public GatewayFilter apply(Object config) {
        return (exchange, chain) -> {
            String val = (String)exchange.getAttribute("bizvane-access-token");
            Client client = this.checkAccessToken(val);
            Optional.of(client).map(Client::getExt).ifPresent(ext -> Optional.ofNullable(ext.get("business_id")).ifPresent(s -> exchange.getAttributes().put("business_id", s)));
            return chain.filter(exchange);
        };
    }

    private Client checkAccessToken(String accessToken) {
        return Optional.ofNullable(this.oauthManager.getClient(accessToken)).orElseThrow(OpenApiExceptionSupplier.convert((CodeMessage)CodeMessageConsts.Gateway.INVALID_ACCESS_TOKEN));
    }
}

