/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.gateway2.config;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.bizvane.openapi.authentication.EnableOauthServer;
import com.bizvane.openapi.common.annotation.EnableResponseCodeMessage;
import com.bizvane.openapi.common.response.ResponseProperties;
import com.bizvane.openapi.gateway2.config.SkipSignatureValidationProperties;
import com.bizvane.openapi.gateway2.webfilter.ReactiveAddTraceIdFilter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
@EnableCaching
@EnableOauthServer
@EnableScheduling
@EnableResponseCodeMessage(value={"com.bizvane.openapi"})
@ComponentScan(value={"com.bizvane.openapi.business", "com.bizvane.openapi.gateway"})
@EnableConfigurationProperties(value={SkipSignatureValidationProperties.class})
public class CommonConfig {
    @Bean
    @ConditionalOnMissingBean
    public PasswordEncoder passwordEncoder() {
        return PasswordEncoderFactories.createDelegatingPasswordEncoder();
    }

    @Bean
    public HttpMessageConverters fastJsonHttpMessageConverters() {
        FastJsonHttpMessageConverter fastConverter = new FastJsonHttpMessageConverter();
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        fastJsonConfig.setSerializerFeatures(new SerializerFeature[]{SerializerFeature.MapSortField});
        fastJsonConfig.setDateFormat("yyyy-MM-dd HH:mm:ss");
        fastConverter.setFastJsonConfig(fastJsonConfig);
        ArrayList fastMediaTypes = Lists.newArrayList((Object[])new MediaType[]{MediaType.APPLICATION_JSON, MediaType.APPLICATION_JSON_UTF8});
        fastConverter.setSupportedMediaTypes((List)fastMediaTypes);
        FastJsonHttpMessageConverter converter = fastConverter;
        return new HttpMessageConverters(new HttpMessageConverter[]{converter});
    }

    @Bean
    @Order(value=-2147483642)
    public ReactiveAddTraceIdFilter reactiveTraceResponse(ResponseProperties properties) {
        return new ReactiveAddTraceIdFilter(properties);
    }
}

