/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.gateway.sentinel;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import com.alibaba.csp.sentinel.property.PropertyListener;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.bizvane.openapi.gateway.sentinel.ServiceValidateRule;
import com.bizvane.openapi.gateway.sentinel.ServiceValidateRuleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class ServiceValidateRuleManager {
    private static Map<String, Set<ServiceValidateRule>> serviceValidateRules = new ConcurrentHashMap();
    private static final RulePropertyListener LISTENER = new RulePropertyListener(null);
    private static SentinelProperty<List<ServiceValidateRule>> currentProperty = new DynamicSentinelProperty();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register2Property(SentinelProperty<List<ServiceValidateRule>> property) {
        AssertUtil.notNull(property, (String)"property cannot be null");
        RulePropertyListener rulePropertyListener = LISTENER;
        synchronized (rulePropertyListener) {
            if (currentProperty != null) {
                currentProperty.removeListener((PropertyListener)LISTENER);
            }
            property.addListener((PropertyListener)LISTENER);
            currentProperty = property;
            RecordLog.info((String)"[ServiceValidateRuleManager] Registering new property to service validate rule manager", (Object[])new Object[0]);
        }
    }

    public static void loadRules(List<ServiceValidateRule> rules) {
        currentProperty.updateValue(rules);
    }

    public static boolean hasConfig(String resource) {
        return serviceValidateRules.containsKey(resource);
    }

    public static List<ServiceValidateRule> getRules() {
        ArrayList<ServiceValidateRule> rules = new ArrayList<ServiceValidateRule>();
        if (serviceValidateRules == null) {
            return rules;
        }
        for (Map.Entry entry : serviceValidateRules.entrySet()) {
            rules.addAll((Collection)entry.getValue());
        }
        return rules;
    }

    public static Map<String, Set<ServiceValidateRule>> getServiceValidateRules() {
        return serviceValidateRules;
    }

    public static boolean isValidRule(ServiceValidateRule rule) {
        return rule != null && !StringUtil.isBlank((String)rule.getResource()) && rule.isSkip();
    }

    static /* synthetic */ Map access$100() {
        return serviceValidateRules;
    }

    static {
        currentProperty.addListener((PropertyListener)LISTENER);
    }
}

