/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.gateway.config;

import com.alibaba.csp.sentinel.adapter.servlet.callback.RequestOriginParser;
import com.alibaba.csp.sentinel.adapter.servlet.callback.UrlBlockHandler;
import com.alibaba.csp.sentinel.adapter.servlet.callback.WebCallbackManager;
import com.alibaba.csp.sentinel.annotation.aspectj.SentinelResourceAspect;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import com.alibaba.csp.sentinel.slots.block.flow.FlowException;
import com.alibaba.csp.sentinel.slots.system.SystemBlockException;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.bizvane.openapi.common.consts.CodeMessageConsts;
import com.bizvane.openapi.common.exception.OpenApiException;
import com.bizvane.openapi.common.response.CodeMessage;
import com.bizvane.openapi.common.response.RestControllerExpAdviceHandler;
import com.bizvane.openapi.gateway.config.SentinelRulesConfig;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.alibaba.nacos.NacosConfigProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnClass(value={NacosConfigProperties.class})
@ConditionalOnBean(value={NacosConfigProperties.class})
@Configuration
public class SentinelRulesConfig {
    public static final String FLOW_DATA_ID_POSTFIX = "-flow-rules";
    public static final String PARAM_FLOW_DATA_ID_POSTFIX = "-param-rules";
    public static final String SYSTEM_DATA_ID_POSTFIX = "-system-rules";
    public static final String AUTHORITY_DATA_ID_POSTFIX = "-authority-rules";
    public static final String SERVICE_VALIDATE_ID_POSTFIX = "-service-validate-rules";
    public static final String DEGRADE_DATA_ID_POSTFIX = "-degrade-rules";
    @Value(value="${spring.application.name}")
    private String appName;
    @Autowired
    NacosConfigProperties nacosConfigProperties;
    @Autowired
    RestControllerExpAdviceHandler handler;

    @Bean
    public SentinelResourceAspect sentinelResourceAspect() {
        return new SentinelResourceAspect();
    }

    @PostConstruct
    public void loadRules() {
        try {
            this.nacosConfigProperties.configServiceInstance().addListener(this.appName + FLOW_DATA_ID_POSTFIX, this.nacosConfigProperties.getGroup(), (Listener)new FlowListener(this));
        }
        catch (NacosException e) {
            e.printStackTrace();
        }
        try {
            this.nacosConfigProperties.configServiceInstance().addListener(this.appName + SYSTEM_DATA_ID_POSTFIX, this.nacosConfigProperties.getGroup(), (Listener)new SystemListener(this));
        }
        catch (NacosException e) {
            e.printStackTrace();
        }
        try {
            this.nacosConfigProperties.configServiceInstance().addListener(this.appName + AUTHORITY_DATA_ID_POSTFIX, this.nacosConfigProperties.getGroup(), (Listener)new AuthorityListener(this));
        }
        catch (NacosException e) {
            e.printStackTrace();
        }
        try {
            this.nacosConfigProperties.configServiceInstance().addListener(this.appName + SERVICE_VALIDATE_ID_POSTFIX, this.nacosConfigProperties.getGroup(), (Listener)new ServiceValidateListener(this));
        }
        catch (NacosException e) {
            e.printStackTrace();
        }
        try {
            this.nacosConfigProperties.configServiceInstance().addListener(this.appName + DEGRADE_DATA_ID_POSTFIX, this.nacosConfigProperties.getGroup(), (Listener)new DegradeListener(this));
        }
        catch (NacosException e) {
            e.printStackTrace();
        }
    }

    @Bean
    public UrlBlockHandler urlBlockHandler() {
        BlockHandler handler = new BlockHandler(this);
        WebCallbackManager.setUrlBlockHandler((UrlBlockHandler)handler);
        return handler;
    }

    @Bean
    public RequestOriginParser requestOriginParser() {
        RequestOriginParser requestOriginParser = request -> {
            String ip = request.getHeader("@");
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("X-Real-IP");
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("Proxy-Client-IP");
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("Proxy-Client-IP");
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("WL-Proxy-Client-IP");
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_CLIENT_IP");
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_X_FORWARDED_FOR");
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getRemoteAddr();
            }
            return ip;
        };
        WebCallbackManager.setRequestOriginParser((RequestOriginParser)requestOriginParser);
        return requestOriginParser;
    }

    public static OpenApiException convert(BlockException ex) {
        OpenApiException exception = null;
        if (ex instanceof FlowException) {
            FlowException e = (FlowException)ex;
            exception = 1 == e.getRule().getGrade() ? OpenApiException.newInstance((CodeMessage)CodeMessageConsts.Limit.FLOW_QPS_LIMIT) : OpenApiException.newInstance((CodeMessage)CodeMessageConsts.Limit.FLOW_THREAD_LIMIT);
        } else if (ex instanceof DegradeException) {
            exception = OpenApiException.newInstance((CodeMessage)CodeMessageConsts.Limit.DEGRADE_LIMIT);
        } else if (ex instanceof AuthorityException) {
            AuthorityException e = (AuthorityException)ex;
            switch (e.getRule().getStrategy()) {
                case 0: {
                    exception = OpenApiException.newInstance((CodeMessage)CodeMessageConsts.Limit.AUTHORITY_WHITE_LIMIT);
                    break;
                }
                case 1: {
                    exception = OpenApiException.newInstance((CodeMessage)CodeMessageConsts.Limit.AUTHORITY_BLACK_LIMIT);
                    break;
                }
                default: {
                    exception = OpenApiException.newInstance((CodeMessage)CodeMessageConsts.Limit.AUTHORITY_LIMIT);
                    break;
                }
            }
        } else {
            exception = ex instanceof SystemBlockException ? OpenApiException.newInstance((CodeMessage)CodeMessage.newInstance((CodeMessage)CodeMessageConsts.Limit.SYSTEM_LIMIT, (String[])new String[]{ex.getRuleLimitApp()})) : OpenApiException.newInstance((CodeMessage)CodeMessageConsts.Limit.FLOW_LIMIT);
        }
        return exception;
    }
}

