package com.bizvane.openapi.gateway.sentinel;

import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.slots.block.AbstractRule;
import com.google.common.collect.Maps;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.util.Map;
import java.util.Objects;
import java.util.Set;


/**
 * @author wang.zeyan
 * 2019/10/12
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class ServiceValidateRule extends AbstractRule {

    private boolean skip;

    /**
     *
     */
    private String appKey;

    private Object businessId;

    /**
     * 扩展验证, key为 http headers中值, value 为可选值匹配
     */
    private Map<String, Set<String>> extValidate = Maps.newHashMap();

    @Override
    public boolean passCheck(Context context, DefaultNode node, int count, Object... args) {
        return true;
    }

}
