package com.bizvane.openapi.gateway.module.token.service.impl;

import com.alibaba.fastjson.JSON;
import com.bizvane.openapi.authentication.AuthenticationService;
import com.bizvane.openapi.authentication.vo.Client;
import com.bizvane.openapi.authentication.vo.Token;
import com.bizvane.openapi.common.utils.SignatureUtils;
import com.bizvane.openapi.gateway.logging.LogUtil;
import com.bizvane.openapi.gateway.module.cache.GatewayManager;
import com.bizvane.openapi.gateway.module.token.service.OauthManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @author wang.zeyan
 * 2019年5月14日
 */
@Service
public class OauthManagerImpl implements OauthManager {

    @Autowired
    AuthenticationService authenticationService;

    @Autowired
    GatewayManager gatewayManager;

    @Override
    public Token accessToken(String appKey, String appSecret) {
        LogUtil.tokenLog.info("AccessToken | appkey: {} | appSecret: {}", appKey, appSecret);
        Client client = gatewayManager.getClient(appKey, appSecret);
        Token accessToken = authenticationService.accessToken(client);
        LogUtil.tokenLog.info("AccessToken | appkey: {} | appSecret: {} | token: {}", appKey, appSecret, JSON.toJSONString(accessToken));
        return accessToken;
    }

    @Override
    public Token refreshToken(String appKey, String refreshToken) {
        LogUtil.tokenLog.info("RefreshToken | appkey: {} | refreshToken: {}", appKey, refreshToken);
        Token accessToken = authenticationService.refreshToken(appKey, refreshToken);
        LogUtil.tokenLog.info("RefreshToken | appkey: {} | refreshToken: {} | token: {}", appKey, refreshToken, JSON.toJSONString(accessToken));
        return accessToken;
    }

    @Override
    public boolean verifySignature(String sign, String accessToken, Map<String, Object> params) {
        LogUtil.requestLog.info("VerifySignature | accessToken: {} | sign: {} | params: {}", accessToken, sign, JSON.toJSONString(params));
        boolean verifySignature = authenticationService.verifySignature(sign, accessToken, params);
        LogUtil.requestLog.info("VerifySignature | accessToken: {} | sign: {} | result: {}", accessToken, sign, verifySignature);
        return verifySignature;
    }

    @Override
    public String signatureWithAppKey(String appKey, Map<String, Object> params) {
        return authenticationService.signature(appKey, params);
    }

    @Override
    public String signatureWithAppSecret(String appSecret, Map<String, Object> params) {
        return SignatureUtils.sign(appSecret, params);
    }

    @Override
    public Client getClient(String accessToken) {
        return authenticationService.getClient(accessToken);
    }
}
