package com.bizvane.openapi.gateway.module.service.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiInfo;
import com.bizvane.openapi.business.modules.api.service.OpenapiApiManager;
import com.bizvane.openapi.business.modules.api.vo.ApiInfoVO;
import com.bizvane.openapi.business.modules.service.entity.OpenapiServiceInfo;
import com.bizvane.openapi.business.modules.service.service.OpenapiServiceManager;
import com.bizvane.openapi.gateway.module.service.service.ServiceManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author wang.zeyan
 * 2019年5月15日
 */
@Service
public class ServiceManagerImpl implements ServiceManager {

    @Autowired
    OpenapiServiceManager openapiServiceManager;

    @Autowired
    OpenapiApiManager apiManager;

    @Override
    public List<OpenapiServiceInfo> listService() {
        return openapiServiceManager.pagePublicService(new Page<OpenapiServiceInfo>(1, 1000).setSearchCount(false)).getRecords();
    }

    @Override
    public OpenapiServiceInfo getServiceInfo(String serviceAlias) {
        return openapiServiceManager.getServiceByAlias(serviceAlias);
    }

    @Override
    public List<OpenapiApiInfo> listApiInfo(String serviceId) {
        return openapiServiceManager.listServiceApi(serviceId);
    }

    @Override
    public ApiInfoVO apiInfo(String apiId) {
        return apiManager.getApiInfoDetail(apiId);
    }

}
