package com.bizvane.openapi.gateway.module.service.service;

import com.bizvane.openapi.business.modules.api.entity.OpenapiApiInfo;
import com.bizvane.openapi.business.modules.api.vo.ApiInfoVO;
import com.bizvane.openapi.business.modules.service.entity.OpenapiServiceInfo;

import java.util.List;

/**
 * @author wang.zeyan
 * 2019年5月15日
 */
public interface ServiceManager {

    /**
     * 获取所有服务
     *
     * @return
     */
    List<OpenapiServiceInfo> listService();


    /**
     * 根据服务alias 获取服务基本信息i
     *
     * @param serviceAlias
     * @return
     */
    OpenapiServiceInfo getServiceInfo(String serviceAlias);

    /**
     * 根据服务Id获取所有接口信息
     *
     * @param serviceId
     * @return
     */
    List<OpenapiApiInfo> listApiInfo(String serviceId);

    /**
     * 接口详情-参数信息-返回信息
     *
     * @param apiId
     * @return
     */
    ApiInfoVO apiInfo(String apiId);
}
