package com.bizvane.openapi.gateway.module.service.controller;

import com.bizvane.openapi.gateway.module.service.service.ServiceManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 
 * @author wang.zeyan
 *  2019年5月15日
 */
@RestController
@Api(tags = "服务")
@RequestMapping("/service")
public class ServiceController {

	@Autowired
	ServiceManager serviceManager;

	@ApiOperation("所有公开的服务")
	@GetMapping
	public Object serviceAll(){
		return serviceManager.listService();
	}


	@ApiOperation("单服务下所有接口")
	@GetMapping("/{serviceId}")
	public Object listApiInfo(@PathVariable String serviceId) {
		return serviceManager.listApiInfo(serviceId);
	}

	@ApiOperation("接口详情-请求信息-返回信息")
	@GetMapping("/api/{apiId}")
	public Object apiInfo(@PathVariable String apiId) {
		return serviceManager.apiInfo(apiId);
	}
}
