package com.bizvane.openapi.gateway.module.cache;

import com.bizvane.openapi.authentication.vo.Client;
import com.bizvane.openapi.business.modules.cache.vo.ServiceApiVO;
import com.bizvane.openapi.business.modules.service.entity.OpenapiServiceInfo;

/**
 * @author wang.zeyan
 * 2019年5月27日
 */
public interface GatewayManager {

    /**
     * 获取client
     *
     * @param appKey
     * @param appSecret
     * @return
     */
    Client getClient(String appKey, String appSecret);

    /**
     * 获取client
     *
     * @param appKey
     * @return
     */
    Client getClient(String appKey);

    /**
     * 获取接口服务信息
     *
     * @param serviceAlias
     * @param apiAlias
     * @return
     */
    ServiceApiVO getServiceApi(String serviceAlias, String apiAlias);

    /**
     * 获取服务基本信息
     *
     * @param serviceAlias
     * @return
     */
    OpenapiServiceInfo getService(String serviceAlias);

}
