package com.bizvane.openapi.gateway.consts;

import static com.bizvane.openapi.common.response.CodeMessage.newInstance;

import com.bizvane.openapi.common.consts.CodeConsts;
import com.bizvane.openapi.common.response.CodeMessage;

/**
 * 
 * @author wang.zeyan
 *  2019年4月11日
 */
public interface CodeMessageConsts {
	
	/**
	 * 网关
	 * @author wang.zeyan
	 *  2019年5月20日
	 */
	public static interface Gateway extends CodeConsts {
		
		
		CodeMessage TIMESTAMP_EMPTY = newInstance(CodeConsts.CLIENT_ERROR, "Empty.Timestamp");
		/**
		 * 用户时间和服务器时间不在N时间内,请检查系统时钟是否准时和系统时区的设置是否为东八区
		 */
		CodeMessage INVALID_TIMESTAMP = newInstance(CodeConsts.CLIENT_ERROR, "Invalid.TimeStamp");
		
		CodeMessage ACCESS_TOKEN_EMPTY = newInstance(CodeConsts.CLIENT_ERROR, "Empty.AccessToken");
		/**
		 * 无效的AccessToken
		 */
		CodeMessage INVALID_ACCESS_TOKEN = newInstance(CodeConsts.CLIENT_ERROR, "Invalid.AccessToken");
		
		CodeMessage NONCE_EMPTY = newInstance(CodeConsts.CLIENT_ERROR, "Empty.Nonce");
		/**
		 * 随机数重复, 同access_token 同url, 15分钟内, nonce参数不能重复
		 */
		CodeMessage NONCE_USED = newInstance(CodeConsts.CLIENT_ERROR, "NonceUsed");
		
		/**
		 * 无效的API地址
		 */
		CodeMessage INVALID_API_NOTFOUND = newInstance(CodeConsts.NOT_FOUND, "InvalidApi.NotFound");
		
		CodeMessage INVALID_SERVICE_NOTFOUND = newInstance(CodeConsts.NOT_FOUND, "InvalidService.NotFound");
		
		CodeMessage SIGNATURE_EMPTY = newInstance(CodeConsts.CLIENT_ERROR, "Empty.Signature");
		/**
		 * 签名不通过
		 */
		CodeMessage SIGNATURE_DOES_NOT_MATCH = newInstance(CodeConsts.CLIENT_ERROR, "Signature.Don'tMatch");
	}
}
