/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.gateway.module.request.service.impl;

import brave.Span;
import brave.Tracer;
import brave.propagation.B3SingleFormat;
import brave.propagation.TraceContext;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.openapi.authentication.vo.Client;
import com.bizvane.openapi.business.modules.cache.vo.ServiceApiParamsVO;
import com.bizvane.openapi.business.modules.cache.vo.ServiceApiVO;
import com.bizvane.openapi.common.consts.CodeConsts;
import com.bizvane.openapi.common.exception.OpenApiException;
import com.bizvane.openapi.common.exception.OpenApiExceptionSupplier;
import com.bizvane.openapi.common.request.HttpRequest;
import com.bizvane.openapi.common.response.CodeMessage;
import com.bizvane.openapi.common.utils.Assert;
import com.bizvane.openapi.gateway.consts.CodeMessageConsts;
import com.bizvane.openapi.gateway.module.cache.GatewayManager;
import com.bizvane.openapi.gateway.module.request.service.RequestManager;
import com.bizvane.openapi.gateway.module.request.vo.RequestVO;
import com.bizvane.openapi.gateway.module.token.service.OauthManager;
import com.bizvane.openapi.gateway.sentinel.ServiceValidateRule;
import com.bizvane.openapi.gateway.sentinel.ServiceValidateRuleManager;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RequestManagerImpl
implements RequestManager {
    @Value(value="${bizvane.openapi.gateway.reject-timeout:900000}")
    private long rejectTimeout;
    @Autowired
    OauthManager oauthManager;
    @Autowired
    CacheManager cacheManager;
    @Autowired
    HttpRequest request;
    @Autowired
    GatewayManager gatewayManager;
    @Autowired
    Tracer tracer;
    @Value(value="${spring.application.name}")
    String appName;
    static Set<String> signatureHeaders = Sets.newHashSet((Object[])new String[]{"bizvane-appkey", "bizvane-timestamp", "bizvane-nonce"});
    static String signatureHeadersValue = Joiner.on((char)',').join((Iterable)signatureHeaders);

    public Object request(String currentPath, String serviceAlias, String apiAlias, Map<String, String> headers, Map<String, Object> body) {
        Set serviceValidateRules = (Set)ServiceValidateRuleManager.getServiceValidateRules().get(serviceAlias);
        AtomicReference businessIdRef = new AtomicReference();
        String appKey = Strings.emptyToNull((String)headers.get("bizvane-appkey"));
        Optional.ofNullable(appKey).map(arg_0 -> ((GatewayManager)this.gatewayManager).getClient(arg_0)).map(Client::getExt).ifPresent(ext -> Optional.ofNullable(ext.get("business_id")).ifPresent(businessIdRef::set));
        if (serviceValidateRules == null || serviceValidateRules.isEmpty()) {
            String timestampStr = Optional.ofNullable(Strings.emptyToNull((String)headers.get("bizvane-timestamp"))).orElseThrow(OpenApiExceptionSupplier.convert((CodeMessage)CodeMessageConsts.Gateway.TIMESTAMP_EMPTY));
            String accessToken = Optional.ofNullable(Strings.emptyToNull((String)headers.get("bizvane-access-token"))).orElseThrow(OpenApiExceptionSupplier.convert((CodeMessage)CodeMessageConsts.Gateway.ACCESS_TOKEN_EMPTY));
            String nonce = Optional.ofNullable(Strings.emptyToNull((String)headers.get("bizvane-nonce"))).orElseThrow(OpenApiExceptionSupplier.convert((CodeMessage)CodeMessageConsts.Gateway.NONCE_EMPTY));
            String signature = Optional.ofNullable(Strings.emptyToNull((String)headers.get("bizvane-signature"))).orElseThrow(OpenApiExceptionSupplier.convert((CodeMessage)CodeMessageConsts.Gateway.SIGNATURE_EMPTY));
            long timestamp = this.checkTimestamp(timestampStr);
            Client client = this.checkAccessToken(accessToken);
            Optional.of(client).map(Client::getExt).ifPresent(ext -> Optional.ofNullable(ext.get("business_id")).ifPresent(businessIdRef::set));
            this.checkReplayAttack(currentPath, accessToken, nonce);
            this.checkSignature(body, accessToken, timestamp, nonce, signature);
        } else {
            ServiceValidateRule rule = (ServiceValidateRule)Lists.newArrayList((Iterable)serviceValidateRules).get(0);
            Map validate = rule.getExtValidate();
            if (!validate.isEmpty()) {
                for (Map.Entry entry : validate.entrySet()) {
                    Set set = (Set)entry.getValue();
                    if (set == null || set.isEmpty() || set.contains(headers.get(entry.getKey()))) continue;
                    throw OpenApiException.newInstance((CodeMessage)CodeMessage.newInstance((CodeMessage)CodeConsts.MISMATCH_PARAMETER_NAME, (String[])new String[]{(String)entry.getKey()}));
                }
            }
            if (businessIdRef.get() == null) {
                Optional.ofNullable(rule.getBusinessId()).ifPresent(businessIdRef::set);
            }
        }
        ServiceApiVO serviceApiVO = this.checkServiceApi(serviceAlias, apiAlias);
        RequestVO requestVO = this.buildRequestParams(serviceApiVO.getRequestParams(), body);
        this.secondSignature(requestVO, serviceApiVO.getAppKey(), serviceApiVO.getAppSecret(), businessIdRef.get());
        return this.request.request(serviceApiVO.getMethod(), serviceApiVO.getUrl(), requestVO.getBodyMap(), requestVO.getParamsMap(), requestVO.getHeadersMap(), JSONObject.class);
    }

    private Client checkAccessToken(String accessToken) {
        return Optional.ofNullable(this.oauthManager.getClient(accessToken)).orElseThrow(OpenApiExceptionSupplier.convert((CodeMessage)CodeMessageConsts.Gateway.INVALID_ACCESS_TOKEN));
    }

    private void secondSignature(RequestVO requestVO, String providerAppKey, String providerAppSecret, Object requestBusinessId) {
        HashMap signatureHeadersMap = Maps.newHashMap();
        signatureHeadersMap.put("bizvane-nonce", RandomStringUtils.randomAlphabetic((int)8));
        signatureHeadersMap.put("bizvane-timestamp", System.currentTimeMillis());
        signatureHeadersMap.put("bizvane-appkey", providerAppKey);
        HashMap params = Maps.newHashMap();
        params.putAll(requestVO.getParamsMap());
        params.putAll(requestVO.getBodyMap());
        params.putAll(signatureHeadersMap);
        String signatureWithAppSecret = this.oauthManager.signatureWithAppSecret(providerAppSecret, (Map)params);
        signatureHeadersMap.put("bizvane-signature-headers", signatureHeadersValue);
        signatureHeadersMap.put("bizvane-request-business-id", requestBusinessId);
        this.tracer.startScopedSpan(this.appName);
        Span span = this.tracer.currentSpan();
        span.kind(Span.Kind.CLIENT);
        signatureHeadersMap.put("b3", B3SingleFormat.writeB3SingleFormat((TraceContext)span.context()));
        signatureHeadersMap.put("bizvane-request-id", span.context().traceIdString());
        signatureHeadersMap.put("bizvane-signature", signatureWithAppSecret);
        requestVO.getHeadersMap().putAll(signatureHeadersMap);
    }

    private RequestVO buildRequestParams(List<ServiceApiParamsVO> requestParams, Map<String, Object> body) {
        RequestVO vo = new RequestVO();
        if (!CollectionUtils.isEmpty(requestParams)) {
            block10: for (ServiceApiParamsVO params : requestParams) {
                String key = params.getParamName();
                Object val = body.get(key);
                switch (params.getRequestType()) {
                    case "header": {
                        vo.getHeadersMap().put(key, val);
                        continue block10;
                    }
                    case "path": {
                        continue block10;
                    }
                    case "body": {
                        vo.getBodyMap().put(key, val);
                        continue block10;
                    }
                }
                vo.getParamsMap().put(key, val);
            }
        }
        return vo;
    }

    private long checkTimestamp(String timestampStr) {
        long timestamp;
        try {
            timestamp = Long.parseLong(timestampStr);
        }
        catch (NumberFormatException e) {
            throw new OpenApiException(CodeMessageConsts.Gateway.INVALID_TIMESTAMP);
        }
        Assert.isTrue((System.currentTimeMillis() - timestamp <= this.rejectTimeout ? 1 : 0) != 0, (CodeMessage)CodeMessageConsts.Gateway.INVALID_TIMESTAMP);
        return timestamp;
    }

    private void checkReplayAttack(String currentPath, String accessToken, String nonce) {
        Cache pathCache = this.cacheManager.getCache("request_path");
        String path = Strings.lenientFormat((String)"%s-%s-%s", (Object[])new Object[]{accessToken, nonce, currentPath});
        Boolean replay = (Boolean)pathCache.get((Object)path, Boolean.class);
        Assert.isNull((Object)replay, (CodeMessage)CodeMessageConsts.Gateway.NONCE_USED);
        pathCache.put((Object)path, (Object)Boolean.TRUE);
    }

    private void checkSignature(Map<String, Object> body, String accessToken, long timestamp, String nonce, String signatrue) {
        body = Optional.ofNullable(body).orElseGet(() -> Maps.newHashMapWithExpectedSize((int)4));
        body.put("bizvane-timestamp", timestamp);
        body.put("bizvane-nonce", nonce);
        body.put("bizvane-access-token", accessToken);
        boolean verifySignature = this.oauthManager.verifySignature(signatrue, accessToken, body);
        Assert.isTrue((boolean)verifySignature, (CodeMessage)CodeMessageConsts.Gateway.SIGNATURE_DOES_NOT_MATCH);
    }

    private ServiceApiVO checkServiceApi(String serviceAlias, String apiAlias) {
        return this.gatewayManager.getServiceApi(serviceAlias, apiAlias);
    }
}

