package com.bizvane.openapi.gateway.module.token.service;

import java.util.Map;

import com.bizvane.openapi.authentication.vo.Client;
import com.bizvane.openapi.authentication.vo.Token;

/**
 * 
 * @author wang.zeyan
 *  2019年5月14日
 */
public interface OauthManager {

	/**
	 * 获取accessToken
	 * @param appKey
	 * @param appSecret
	 * @return
	 */
	Token accessToken(String appKey, String appSecret);
	
	/**
	 * 刷新token
	 * @param appKey
	 * @param refreshToken
	 * @return
	 */
	Token refreshToken(String appKey, String refreshToken);
	
	/**
	 * 验证签名
	 * @param sign
	 * @param accessToken
	 * @param params
	 * @return
	 */
	boolean verifySignature(String sign, String accessToken, Map<String, Object> params); 
	
	/**
	 * 根据appkey查询appSecret签名
	 * @param appKey
	 * @param params
	 * @return
	 */
	String signatureWithAppKey(String appKey, Map<String, Object> params);
	
	/**
	 * 获取开发者/服务者账号信息
	 * @param accessToken
	 * @return
	 */
	Client getClient(String accessToken);

	/**
	 * 根据appSecret签名
	 * @param appSecret
	 * @param params
	 * @return
	 */
	String signatureWithAppSecret(String appSecret, Map<String, Object> params);
}
