package com.bizvane.openapi.gateway.module.token.controller;

import brave.Tracer;
import com.bizvane.openapi.gateway.module.token.service.OauthManager;
import com.bizvane.openapi.gateway.module.token.vo.AccessTokenVO;
import com.bizvane.openapi.gateway.module.token.vo.RefreshTokenVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wang.zeyan
 * 2019年5月14日
 */
@RestController
@RequestMapping("/oauth2")
@Api(tags = "令牌")
public class OauthController {

    @Autowired
    OauthManager oauthManager;

    @Autowired
    Tracer tracer;

    @ApiOperation("获取token")
    @PostMapping("/accessToken")
    public Object getToken(@RequestBody AccessTokenVO vo) {
        return oauthManager.accessToken(vo.getAppKey(), vo.getAppSecret());
    }

    @ApiOperation("刷新token")
    @PostMapping("/refreshToken")
    public Object refreshToken(@RequestBody RefreshTokenVO vo) {
        return oauthManager.refreshToken(vo.getAppKey(), vo.getRefreshToken());
    }
}
