package com.bizvane.openapi.gateway.module.request.controller;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.bizvane.openapi.gateway.config.SentinelRulesConfig;
import com.bizvane.openapi.gateway.module.request.service.RequestManager;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.HandlerMapping;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * 
 * @author wang.zeyan
 *  2019年5月20日
 */
@Api(tags = "接口请求")
@RestController
@RequestMapping("/request")
public class RequestController {
	
	@Autowired
	RequestManager requestManager;
	
	@Autowired
	HttpServletRequest request;

	@PostMapping("/{serviceAlias}/{apiAlias}")
	public Object request(
			@PathVariable String serviceAlias,
			@PathVariable String apiAlias,
			@RequestHeader Map<String, String> headers,
			@RequestBody Map<String, Object> body) {

		String currentPath =  String.valueOf(request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE));
		Entry entry = null;
		String entryName = "Service-" + serviceAlias;
		try {
			entry = SphU.entry(entryName, EntryType.IN);
			LinkedCaseInsensitiveMap<String> caseInsensitiveHeaders = new LinkedCaseInsensitiveMap<>();
			caseInsensitiveHeaders.putAll(headers);
			Object result = requestManager.request(currentPath, serviceAlias, apiAlias, caseInsensitiveHeaders, body);
			return result;
		}catch (BlockException ex){
			throw SentinelRulesConfig.convert(ex);
		}finally {
			if(entry != null){
				entry.exit();
			}
		}

	}
	
}


