package com.bizvane.openapi.gateway.module.cache.impl;

import com.bizvane.openapi.authentication.AuthenticationService;
import com.bizvane.openapi.authentication.consts.CodeMessageConsts;
import com.bizvane.openapi.authentication.vo.Client;
import com.bizvane.openapi.business.consts.CacheConsts;
import com.bizvane.openapi.business.modules.cache.vo.ServiceApiVO;
import com.bizvane.openapi.business.modules.developeraccount.service.OpenapiDeveloperAccountManager;
import com.bizvane.openapi.business.modules.service.entity.OpenapiServiceInfo;
import com.bizvane.openapi.business.modules.service.service.OpenapiServiceManager;
import com.bizvane.openapi.common.consts.StringConsts;
import com.bizvane.openapi.common.exception.OpenApiExceptionSupplier;
import com.bizvane.openapi.gateway.module.cache.GatewayManager;
import com.google.common.base.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;

import static com.bizvane.openapi.common.utils.Assert.*;
import static com.bizvane.openapi.common.utils.Assert.isTrue;

/**
 * 
 * @author wang.zeyan
 *  2019年5月27日
 */
@Service
public class GatewayCacheManagerImpl implements GatewayManager {

	@Autowired
	OpenapiDeveloperAccountManager developerAccountManager;
	
	@Autowired
	AuthenticationService authenticationService;
	
	@Autowired
	CacheManager cacheManager;
	
	@Autowired
	OpenapiServiceManager serviceManager;



	@Override
	public ServiceApiVO getServiceApi(String serviceAlias, String apiAlias) {
		
		/*String key = String.format("%s-%s", serviceAlias, apiAlias);
        ServiceApiVO serviceApi = cacheManager.getCache(CacheConsts.SERVICE_API).get(key, ServiceApiVO.class);
		if(serviceApi != null) {
			return serviceApi;
		}
		serviceApi = serviceManager.getServiceApiDetail(serviceAlias, apiAlias);
		Assert.notNull(serviceApi, com.bizvane.openapi.gateway.consts.CodeMessageConsts.Gateway.INVALID_API_NOTFOUND);
		
		cacheManager.getCache(CacheConsts.SERVICE_API).put(key, serviceApi);
		return serviceApi;*/

		String key = Strings.lenientFormat("%s-%s", serviceAlias, apiAlias);

		Supplier<ServiceApiVO> getInCache = () -> cacheManager.getCache(CacheConsts.SERVICE_API).get(key, ServiceApiVO.class);

		Supplier<ServiceApiVO> getInDb = () -> {
			ServiceApiVO sav = Optional.ofNullable(serviceManager.getServiceApiDetail(serviceAlias, apiAlias))
					.orElseThrow(OpenApiExceptionSupplier.convert(com.bizvane.openapi.gateway.consts.CodeMessageConsts.Gateway.INVALID_API_NOTFOUND));
			cacheManager.getCache(CacheConsts.SERVICE_API).put(key, sav);
			return sav;
		};

        return Optional.ofNullable(getInCache.get()).orElseGet(getInDb);
	}

	@Override
	public OpenapiServiceInfo getService(String serviceAlias) {
		return null;
	}

	@Override
	public Client getClient(String appKey, String appSecret) {
		hasText(appKey, CodeMessageConsts.Authentication.APP_KEY_EMPTY);
		hasText(appSecret, CodeMessageConsts.Authentication.APP_SECRET_EMPTY);
		
		Client client = this.getClient(appKey);
		notNull(client, CodeMessageConsts.Authentication.INVALID_APP_KEY);
		isTrue(appSecret.equals(client.getAppSecret()), CodeMessageConsts.Authentication.APPKEY_APPSECRET_MISMATCH);
		return client;
	}

	@Override
	public Client getClient(String appKey) {

		notNull(appKey, CodeMessageConsts.Authentication.APP_KEY_EMPTY);

		return Optional.ofNullable(authenticationService.getClientWithAppKey(appKey)).orElseGet(() -> {

			AtomicReference<Client> clientRef = new AtomicReference<>();
			Optional.ofNullable(developerAccountManager.getDeveloperAccount(appKey)).ifPresent( da -> {
				Client client = new Client();
				client.setAppKey(da.getAppKey());
				client.setAppSecret(da.getAppSecret());
				client.addExt(StringConsts.BUSINESS_ID, da.getBusinessId());
				authenticationService.cacheClient(client);
				clientRef.set(client);
			});

			return clientRef.get();
		});

		/*Client clientWithAppKey = authenticationService.getClientWithAppKey(appKey);
		if(clientWithAppKey != null) {
			return clientWithAppKey;
		}
		
		OpenapiDeveloperAccount developerAccount = developerAccountManager.getDeveloperAccount(appKey);
		if(developerAccount == null) {
			return null;
		}
		
		Client client = new Client();
		client.setAppKey(developerAccount.getAppKey());
		client.setAppSecret(developerAccount.getAppSecret());
		client.addExt(StringConsts.BUSINESS_ID, developerAccount.getBusinessId());
		authenticationService.cacheClient(client);
		return client;*/
	}
}
