package com.bizvane.openapi.gateway.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import io.swagger.annotations.Api;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * 
 * @author wang.zeyan
 *  2019年4月19日
 */
@Configuration
@EnableSwagger2
public class Swagger2Config {

	@Bean
    public Docket api() {
        return new Docket(DocumentationType.SWAGGER_2)
        	.apiInfo(apiEndPointsInfo())
        	.select()
            .apis(RequestHandlerSelectors.withClassAnnotation(Api.class))
            .paths(PathSelectors.any())
            .build();
    }
	
	private ApiInfo apiEndPointsInfo() {
        return new ApiInfoBuilder().title("Spring Boot Rest API")
            .description("Bizvane OpenApi Gateway Rest API")
            .contact(new Contact("上海商帆信息科技有限公司", "www.bizvane.com", "1000@qq.com"))
            .license("bizvane")
            .version("1.0.0")
            .build();
    }
}
