/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Maps;
import java.util.Base64;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureUtils {
    static Logger logger = LoggerFactory.getLogger(SignatureUtils.class);
    static final String DEFAULT_JOIN1 = "=";
    static final String DEFAULT_JOIN2 = "&";
    static final String EMPTY = "";
    static final Base64.Encoder ENCODER = Base64.getEncoder();

    public static String sign(String rawData) {
        if (rawData == null || rawData.trim().length() == 0) {
            throw new IllegalArgumentException("RawData cannot be null");
        }
        logger.info("Sign | RawData:{}", (Object)rawData);
        return DigestUtils.md5Hex((byte[])ENCODER.encode(rawData.getBytes()));
    }

    public static String sign(String appSecret, Map<String, Object> map) {
        if (map == null || map.size() == 0) {
            throw new IllegalArgumentException("Map cannot be null");
        }
        if (map instanceof TreeMap) {
            return SignatureUtils.sign(appSecret, (TreeMap)map);
        }
        TreeMap treeMap = Maps.newTreeMap();
        treeMap.putAll(map);
        return SignatureUtils.sign(appSecret, treeMap);
    }

    public static String sign(String appSecret, TreeMap<String, Object> treeMap) {
        if (treeMap == null || treeMap.size() == 0) {
            throw new IllegalArgumentException("TreeMap cannot be null");
        }
        if (!treeMap.containsKey("bizvane-appsecret")) {
            treeMap.put("bizvane-appsecret", appSecret);
        }
        String rawData = SignatureUtils.transform(treeMap);
        String signature = SignatureUtils.sign(rawData);
        treeMap.remove("bizvane-appsecret");
        return signature;
    }

    private static boolean verifySign(String rawData, String sign) {
        if (logger.isDebugEnabled()) {
            logger.debug("RawData:{}", (Object)rawData);
            logger.debug("Sign:{}", (Object)sign);
        }
        logger.info("VerifySign | RawData:{}", (Object)rawData);
        if (rawData == null || rawData.trim().length() == 0) {
            throw new IllegalArgumentException("RawData cannot be null");
        }
        if (sign == null || sign.trim().length() == 0) {
            throw new IllegalArgumentException("Signature cannot be null");
        }
        String verifySign = DigestUtils.md5Hex((byte[])ENCODER.encode(rawData.getBytes()));
        logger.info("VerifySign | {} : {}", (Object)sign, (Object)verifySign);
        return sign.equalsIgnoreCase(verifySign);
    }

    public static boolean verifySign(String appSecret, Map<String, Object> map, String sign) {
        if (map == null || map.size() == 0) {
            throw new IllegalArgumentException("Map cannot be null");
        }
        if (map instanceof TreeMap) {
            return SignatureUtils.verifySign(appSecret, (TreeMap)map, sign);
        }
        TreeMap treeMap = Maps.newTreeMap();
        treeMap.putAll(map);
        return SignatureUtils.verifySign(appSecret, treeMap, sign);
    }

    public static boolean verifySign(String appSecret, TreeMap<String, Object> treeMap, String sign) {
        if (treeMap == null || treeMap.size() == 0) {
            throw new IllegalArgumentException("TreeMap cannot be null");
        }
        if (!treeMap.containsKey("bizvane-appsecret")) {
            treeMap.put("bizvane-appsecret", appSecret);
        }
        String rawData = SignatureUtils.transform(treeMap);
        boolean verify = SignatureUtils.verifySign(rawData, sign);
        treeMap.remove("bizvane-appsecret");
        return verify;
    }

    private static String transform(TreeMap<String, Object> treeMap) {
        StringBuilder stringBuilder = new StringBuilder();
        int index = 0;
        for (Map.Entry<String, Object> entry : treeMap.entrySet()) {
            if (entry.getValue() == null || entry.getValue().equals(EMPTY)) continue;
            if (index++ > 0) {
                stringBuilder.append(DEFAULT_JOIN2);
            }
            stringBuilder.append(entry.getKey()).append(DEFAULT_JOIN1);
            if (entry.getValue() instanceof String) {
                stringBuilder.append(entry.getValue());
                continue;
            }
            stringBuilder.append(JSON.toJSONString((Object)entry.getValue(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.MapSortField}));
        }
        return stringBuilder.toString();
    }
}

