/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.common.utils;

import com.bizvane.openapi.common.consts.CodeConsts;
import com.bizvane.openapi.common.exception.OpenApiException;
import com.bizvane.openapi.common.response.CodeMessage;
import java.util.Collection;
import java.util.Map;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class Assert {
    public static void isTrue(boolean expression, CodeMessage codeMessage) {
        if (!expression) {
            throw new OpenApiException(codeMessage);
        }
    }

    public static void missing(String text, String ... args) {
        Assert.hasText(text, CodeMessage.newInstance(CodeConsts.MISSING_PARAMETER_NAME, args));
    }

    public static void missing(Object object, String ... args) {
        Assert.notNull(object, CodeMessage.newInstance(CodeConsts.MISSING_PARAMETER_NAME, args));
    }

    public static void notInvalidResource(Object object, String ... args) {
        Assert.notNull(object, CodeMessage.newInstance(CodeConsts.INVALID_RESOURCE_NOT_FOUND, args));
    }

    @Deprecated
    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new OpenApiException(new CodeMessage(CodeConsts.CLIENT_ERROR, message));
        }
    }

    public static void notNull(Object object, CodeMessage codeMessage) {
        if (object == null) {
            throw new OpenApiException(codeMessage);
        }
    }

    @Deprecated
    public static void isNull(Object object, String message) {
        if (object != null) {
            throw new OpenApiException(new CodeMessage(CodeConsts.CLIENT_ERROR, message));
        }
    }

    public static void isNull(Object object, CodeMessage codeMessage) {
        if (object != null) {
            throw new OpenApiException(codeMessage);
        }
    }

    @Deprecated
    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new OpenApiException(new CodeMessage(CodeConsts.CLIENT_ERROR, message));
        }
    }

    public static void hasLength(String text, CodeMessage codeMessage) {
        if (!StringUtils.hasLength((String)text)) {
            throw new OpenApiException(codeMessage);
        }
    }

    @Deprecated
    public static void hasLength(String text, String message) {
        if (!StringUtils.hasLength((String)text)) {
            throw new OpenApiException(new CodeMessage(CodeConsts.CLIENT_ERROR, message));
        }
    }

    public static void hasText(String text, CodeMessage codeMessage) {
        if (!StringUtils.hasText((String)text)) {
            throw new OpenApiException(codeMessage);
        }
    }

    @Deprecated
    public static void hasText(String text, String message) {
        if (!StringUtils.hasText((String)text)) {
            throw new OpenApiException(new CodeMessage(CodeConsts.CLIENT_ERROR, message));
        }
    }

    public static void notEmpty(Collection<?> collection, CodeMessage codeMessage) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new OpenApiException(codeMessage);
        }
    }

    @Deprecated
    public static void notEmpty(Collection<?> collection, String message) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new OpenApiException(new CodeMessage(CodeConsts.CLIENT_ERROR, message));
        }
    }

    public static void notEmpty(Map<?, ?> map, CodeMessage codeMessage) {
        if (CollectionUtils.isEmpty(map)) {
            throw new OpenApiException(codeMessage);
        }
    }

    @Deprecated
    public static void notEmpty(Map<?, ?> map, String message) {
        if (CollectionUtils.isEmpty(map)) {
            throw new OpenApiException(new CodeMessage(CodeConsts.CLIENT_ERROR, message));
        }
    }
}

