/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.common.trace;

import com.bizvane.openapi.common.trace.TraceControllerAspect;
import com.bizvane.openapi.common.trace.TraceControllerProperties;
import java.util.regex.Pattern;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={TraceControllerProperties.class})
public class TraceControllerAutoConfiguration {

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public static class TraceReactive {
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public static class TraceServlet {
        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"bizvane.trace.controller.enabled"}, matchIfMissing=true)
        public TraceControllerAspect tranceControllerAspect(TraceControllerProperties properties) {
            return new TraceControllerAspect(Pattern.compile(properties.getSkipPattern()), properties);
        }
    }
}

