/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.common.retrofit;

import com.bizvane.openapi.common.request.HttpRequest;
import com.bizvane.openapi.common.request.HttpRequestHandler;
import com.bizvane.openapi.common.retrofit.HttpService;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

@Configuration
@ConditionalOnClass(value={Retrofit.class})
@ConditionalOnBean(value={OkHttpClient.class})
public class RetrofitAutoConfiguration {
    Logger log = LoggerFactory.getLogger(RetrofitAutoConfiguration.class);

    @Bean(value={"bizvane-retrofit"})
    public Retrofit retrofit(OkHttpClient okHttpClient) {
        this.log.info("Create retrofit");
        Retrofit retrofit = new Retrofit.Builder().client(okHttpClient).baseUrl("http://www.bizvane.com").addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build();
        return retrofit;
    }

    @Bean
    public HttpService httpService(Retrofit retrofit) {
        this.log.info("Create retrofit httpService");
        return (HttpService)retrofit.create(HttpService.class);
    }

    @Bean
    public HttpRequest httpRequest(HttpService httpService) {
        this.log.info("Create httpRequest");
        return new HttpRequestHandler(httpService);
    }
}

