/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.common.okhttp3;

import com.bizvane.openapi.common.okhttp3.OkHttp3Properties;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={OkHttpClient.class})
@EnableConfigurationProperties(value={OkHttp3Properties.class})
public class OkHttp3AutoConfiguration {
    Logger log = LoggerFactory.getLogger(OkHttp3AutoConfiguration.class);

    @ConditionalOnMissingBean
    @Bean(value={"bizvane-okHttpClient"})
    public OkHttpClient okHttpClient(OkHttp3Properties properties, ApplicationContext context) {
        this.log.info("Create okHttpClient");
        OkHttpClient.Builder builder = new OkHttpClient().newBuilder();
        builder.readTimeout(properties.getReadTimeout(), properties.getTimeUnit()).writeTimeout(properties.getWriteTimeout(), properties.getTimeUnit()).connectTimeout(properties.getConnectTimeout(), properties.getTimeUnit()).followRedirects(properties.isFollowRedirects());
        String[] beanNames = context.getBeanNamesForType(Interceptor.class);
        if (beanNames != null && beanNames.length > 0) {
            for (String beanName : beanNames) {
                Interceptor bean = (Interceptor)context.getBean(beanName, Interceptor.class);
                builder.addInterceptor(bean);
            }
        }
        return builder.build();
    }
}

