/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.common.listener;

import com.p6spy.engine.spy.P6SpyOptions;
import java.util.Collection;
import java.util.Map;
import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.CollectionUtils;

public class P6spyConfigListener
implements ApplicationListener<ApplicationContextInitializedEvent>,
Ordered {
    private static final String DEFAULT_P6SPY_NAME = "p6spy.properties";

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void onApplicationEvent(ApplicationContextInitializedEvent event) {
        ConfigurableEnvironment environment = event.getApplicationContext().getEnvironment();
        String p6spyName = environment.getProperty("config.p6spy", environment.getProperty("spring.application.name") + "-p6spy.properties");
        MutablePropertySources propertySources = environment.getPropertySources();
        PropertySource propertySource = propertySources.get("bootstrapProperties");
        if (propertySource == null) {
            return;
        }
        if (propertySource instanceof CompositePropertySource) {
            CompositePropertySource cp = (CompositePropertySource)propertySource;
            PropertySource<?> nacosSource = this.getSource("NACOS", cp.getPropertySources());
            if (nacosSource == null) {
                return;
            }
            if (nacosSource instanceof CompositePropertySource) {
                CompositePropertySource nacos = (CompositePropertySource)nacosSource;
                PropertySource<?> p6spySource = this.getSource(p6spyName, nacos.getPropertySources());
                if (p6spySource == null) {
                    return;
                }
                Object source = p6spySource.getSource();
                if (source == null || !(source instanceof Map)) {
                    return;
                }
                Map options = (Map)source;
                if (CollectionUtils.isEmpty((Map)options)) {
                    p6spySource = this.getSource(DEFAULT_P6SPY_NAME, nacos.getPropertySources());
                    if (p6spySource == null) {
                        return;
                    }
                    source = p6spySource.getSource();
                    if (source == null || !(source instanceof Map)) {
                        return;
                    }
                    options = (Map)source;
                }
                P6SpyOptions.getActiveInstance().load(options);
            }
        }
    }

    private PropertySource<?> getSource(String sourceName, Collection<PropertySource<?>> collectionSource) {
        for (PropertySource<?> subSource : collectionSource) {
            if (!sourceName.equals(subSource.getName())) continue;
            return subSource;
        }
        return null;
    }
}

