/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.common.exception;

import com.bizvane.openapi.common.response.CodeMessage;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.web.server.ResponseStatusException;

public class OpenApiException
extends ResponseStatusException {
    private static final long serialVersionUID = 1L;
    private CodeMessage codeMessage;

    public OpenApiException(CodeMessage codeMessage) {
        super(codeMessage.getCode(), codeMessage.getMsg());
        this.codeMessage = codeMessage;
    }

    public OpenApiException(CodeMessage codeMessage, Throwable cause) {
        super(codeMessage.getCode(), codeMessage.getMsg(), cause);
        this.codeMessage = codeMessage;
    }

    public CodeMessage getCodeMessage() {
        return this.codeMessage;
    }

    private void setCodeMessage(CodeMessage codeMessage) {
        this.codeMessage = codeMessage;
    }

    public static OpenApiException newInstance(CodeMessage codeMessage) {
        return new OpenApiException(codeMessage);
    }

    public static OpenApiException newInstance(CodeMessage codeMessage, Throwable cause) {
        return new OpenApiException(codeMessage, cause);
    }

    public static OpenApiException newInstanceWithRootCause(CodeMessage codeMessage, Throwable cause) {
        CodeMessage cm = CodeMessage.newInstance(codeMessage.getCode(), codeMessage.getMsg());
        cm.setMsg(String.format("%s[%s]", cm.getMsg(), ExceptionUtils.getRootCauseMessage((Throwable)cause)));
        return new OpenApiException(cm, cause);
    }
}

