/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.common.cache.redis;

import com.bizvane.openapi.common.cache.redis.CustomRedisCacheProperties;
import com.bizvane.openapi.common.cache.redis.RedisProperties;
import com.bizvane.openapi.common.cache.redis.RedissonSpringCacheCustomManager;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.spring.cache.CacheConfig;
import org.redisson.spring.starter.RedissonAutoConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.data.redis.cache.RedisCacheConfiguration;

@Configuration
@AutoConfigureAfter(value={RedisAutoConfiguration.class, RedissonAutoConfiguration.class})
@ConditionalOnClass(value={RedissonClient.class, RedisCacheConfiguration.class, RedissonAutoConfiguration.class})
@EnableConfigurationProperties(value={CustomRedisCacheProperties.class})
@ConditionalOnProperty(name={"spring.cache.type"}, havingValue="redis")
@EnableAspectJAutoProxy(exposeProxy=true, proxyTargetClass=true)
public class RedisCacheAutoConfiguration {
    Logger logger = LoggerFactory.getLogger(RedissonAutoConfiguration.class);

    @Bean
    public CacheManager cacheManager(RedissonClient redissonClient, CustomRedisCacheProperties porperties) {
        this.logger.info("RedisCacheAutoConfiguration create... ");
        HashMap configs = Maps.newHashMap();
        if (!porperties.getCaches().isEmpty()) {
            for (Map.Entry<String, RedisProperties> entry : porperties.getCaches().entrySet()) {
                CacheConfig config = new CacheConfig(entry.getValue().getTtl().toMillis(), 0L);
                configs.put(entry.getKey(), config);
            }
        }
        RedissonSpringCacheCustomManager cacheManager = new RedissonSpringCacheCustomManager(redissonClient, configs, (Codec)JsonJacksonCodec.INSTANCE);
        cacheManager.setTtl(porperties.getTtl());
        return cacheManager;
    }
}

