/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.common.trace;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bizvane.openapi.common.trace.TraceControllerProperties;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.HandlerMapping;

@Aspect
public class TraceControllerAspect {
    final String GET_DELETE_ASPECT = "@within(org.springframework.web.bind.annotation.RestController) && (@annotation(org.springframework.web.bind.annotation.GetMapping) || @annotation(org.springframework.web.bind.annotation.DeleteMapping))";
    final String POST_PUT_ASPECT = "@within(org.springframework.web.bind.annotation.RestController) && (@annotation(org.springframework.web.bind.annotation.PostMapping) || @annotation(org.springframework.web.bind.annotation.PutMapping))";
    final Pattern skipPattern;
    final Logger logger;
    final TraceControllerProperties properties;

    public static HttpServletRequest getRequest() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = requestAttributes.getRequest();
        return request;
    }

    public TraceControllerAspect(Pattern skipPattern, TraceControllerProperties properties) {
        this.skipPattern = skipPattern;
        this.properties = properties;
        this.logger = LoggerFactory.getLogger((String)Optional.ofNullable(properties).map(TraceControllerProperties::getLoggerName).orElse(this.getClass().getName()));
    }

    @Around(value="@within(org.springframework.web.bind.annotation.RestController) && (@annotation(org.springframework.web.bind.annotation.GetMapping) || @annotation(org.springframework.web.bind.annotation.DeleteMapping))")
    public Object getAndDeleteAround(ProceedingJoinPoint pjp) throws Throwable {
        return this.around("@within(org.springframework.web.bind.annotation.RestController) && (@annotation(org.springframework.web.bind.annotation.GetMapping) || @annotation(org.springframework.web.bind.annotation.DeleteMapping))", pjp);
    }

    @Around(value="@within(org.springframework.web.bind.annotation.RestController) && (@annotation(org.springframework.web.bind.annotation.PostMapping) || @annotation(org.springframework.web.bind.annotation.PutMapping))")
    public Object postAndPutAround(ProceedingJoinPoint pjp) throws Throwable {
        return this.around("@within(org.springframework.web.bind.annotation.RestController) && (@annotation(org.springframework.web.bind.annotation.PostMapping) || @annotation(org.springframework.web.bind.annotation.PutMapping))", pjp);
    }

    public Object around(String aspect, ProceedingJoinPoint pjp) throws Throwable {
        Log logStart = this.logStart(aspect, pjp);
        this.logger.info(logStart.getOut().toString(), (Object[])logStart.getArgumentsList().stream().toArray(Object[]::new));
        Stopwatch stopwatch = Stopwatch.createStarted();
        Object result = null;
        try {
            Object object = result = pjp.proceed();
            return object;
        }
        catch (Exception e) {
            result = ExceptionUtils.getRootCauseMessage((Throwable)e);
            throw e;
        }
        finally {
            Log logEnd = this.logEnd(result, stopwatch);
            long ms = stopwatch.elapsed(TimeUnit.MILLISECONDS);
            if (this.properties.getSlowThreshold() != null && ms > this.properties.getSlowThreshold().toMillis()) {
                this.logger.error(logEnd.getOut().toString(), (Object[])logEnd.getArgumentsList().stream().toArray(Object[]::new));
            }
            this.logger.info(logEnd.getOut().toString(), (Object[])logEnd.getArgumentsList().stream().toArray(Object[]::new));
        }
    }

    private Log logStart(String aspect, ProceedingJoinPoint pjp) {
        HttpServletRequest request = TraceControllerAspect.getRequest();
        Log log = new Log();
        log.log("Start").logNext(request.getMethod()).logNext(request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE));
        if (this.properties.isOutRequestQuery() && StringUtils.hasText((String)request.getQueryString())) {
            log.logNext("query", request.getQueryString());
        }
        if ("@within(org.springframework.web.bind.annotation.RestController) && (@annotation(org.springframework.web.bind.annotation.PostMapping) || @annotation(org.springframework.web.bind.annotation.PutMapping))".equals(aspect)) {
            int bodyIndex = this.isUseBody(pjp);
            if (bodyIndex > -1) {
                if (this.properties.isOutRequestBody()) {
                    log.logNext("body", JSON.toJSONString((Object)pjp.getArgs()[bodyIndex], (SerializerFeature[])new SerializerFeature[]{SerializerFeature.MapSortField}));
                }
            } else if (this.properties.isOutRequestForm()) {
                log.logNext("form", JSON.toJSONString((Object)request.getParameterMap()));
            }
        }
        if (this.properties.isOutRequestHeader()) {
            HashMap headersMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(this.properties.getOutRequestHeaderNames())) {
                for (String headerName : this.properties.getOutRequestHeaderNames()) {
                    headersMap.put(headerName, request.getHeader(headerName));
                }
            } else {
                Enumeration headerNames = request.getHeaderNames();
                while (headerNames.hasMoreElements()) {
                    String headerName = (String)headerNames.nextElement();
                    headersMap.put(headerName, request.getHeader(headerName));
                }
            }
            log.logNext("headers", JSON.toJSONString((Object)headersMap));
        }
        return log;
    }

    private Log logEnd(Object result, Stopwatch stopwatch) {
        HttpServletRequest request = TraceControllerAspect.getRequest();
        Log log = new Log();
        log.log("End").logNext(request.getMethod()).logNext(request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE));
        stopwatch.stop();
        long us = stopwatch.elapsed(TimeUnit.MICROSECONDS);
        log.logNext("cost", us + " \u03bcs");
        log.logNext(stopwatch);
        if (this.properties.isOutResponseResult()) {
            String resultStr = JSON.toJSONString((Object)result);
            if (this.properties.getOutResponseMaxLenth() > 0 && resultStr.length() > this.properties.getOutResponseMaxLenth()) {
                resultStr = resultStr.substring(0, this.properties.getOutResponseMaxLenth()) + "\u2026\u2026\u2026\u2026(\u7701\u7565)";
            }
            log.logNext("result", resultStr);
        }
        return log;
    }

    int isUseBody(ProceedingJoinPoint pjp) {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            Annotation[] annotationArray;
            for (Annotation annotation : annotationArray = annotations[i]) {
                if (!annotation.annotationType().isAssignableFrom(RequestBody.class)) continue;
                return i;
            }
        }
        return -1;
    }

    static class Log {
        private StringBuilder out = new StringBuilder();
        private List<Object> argumentsList = Lists.newArrayList();

        public Log logNext(Object val) {
            this.out.append(" | {}");
            this.argumentsList.add(val);
            return this;
        }

        public Log log(String describe) {
            this.out.append("{}");
            this.argumentsList.add(describe);
            return this;
        }

        public Log logNext(String describe, Object val) {
            this.out.append(" | {}: {}");
            this.argumentsList.add(describe);
            this.argumentsList.add(val);
            return this;
        }

        public StringBuilder getOut() {
            return this.out;
        }

        public List<Object> getArgumentsList() {
            return this.argumentsList;
        }

        public void setOut(StringBuilder out) {
            this.out = out;
        }

        public void setArgumentsList(List<Object> argumentsList) {
            this.argumentsList = argumentsList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Log)) {
                return false;
            }
            Log other = (Log)o;
            if (!other.canEqual(this)) {
                return false;
            }
            StringBuilder this$out = this.getOut();
            StringBuilder other$out = other.getOut();
            if (this$out == null ? other$out != null : !this$out.equals(other$out)) {
                return false;
            }
            List<Object> this$argumentsList = this.getArgumentsList();
            List<Object> other$argumentsList = other.getArgumentsList();
            return !(this$argumentsList == null ? other$argumentsList != null : !((Object)this$argumentsList).equals(other$argumentsList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Log;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            StringBuilder $out = this.getOut();
            result = result * 59 + ($out == null ? 43 : $out.hashCode());
            List<Object> $argumentsList = this.getArgumentsList();
            result = result * 59 + ($argumentsList == null ? 43 : ((Object)$argumentsList).hashCode());
            return result;
        }

        public String toString() {
            return "TraceControllerAspect.Log(out=" + this.getOut() + ", argumentsList=" + this.getArgumentsList() + ")";
        }
    }
}

