/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.common.response;

import com.bizvane.openapi.common.consts.CodeConsts;
import com.bizvane.openapi.common.exception.OpenApiException;
import com.bizvane.openapi.common.response.Response;
import com.bizvane.openapi.common.response.ResponseProperties;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice(annotations={RestController.class})
public class RestControllerExpAdviceHandler
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(RestControllerExpAdviceHandler.class);
    private ResponseProperties properties = new ResponseProperties();
    private boolean diffCode;
    private boolean diffResult;

    public RestControllerExpAdviceHandler() {
        this.diffProperties();
    }

    public RestControllerExpAdviceHandler(ResponseProperties properties) {
        this.properties = properties;
        this.diffProperties();
    }

    private void diffProperties() {
        if (!"bizvane-code".equals(this.properties.getCode())) {
            this.diffCode = true;
        }
        if (!"bizvane-result".equals(this.properties.getResult())) {
            this.diffResult = true;
        }
    }

    @ExceptionHandler(value={Exception.class})
    public Response defaultExceptionHandler(Exception e, HttpServletResponse response) throws Exception {
        if (AnnotationUtils.findAnnotation(e.getClass(), ResponseStatus.class) != null) {
            throw e;
        }
        String requestId = MDC.get((String)"traceId");
        Response result = null;
        if (StringUtils.hasText((String)requestId)) {
            if (this.properties.getIdOutMode() == ResponseProperties.OutMode.Body) {
                result = new Response();
                result.put(this.properties.getId(), (Object)requestId);
            } else {
                response.addHeader(this.properties.getId(), requestId);
            }
        }
        HttpStatus code = CodeConsts.SERVER_ERROR;
        String message = null;
        if (e instanceof OpenApiException) {
            OpenApiException exception = (OpenApiException)((Object)e);
            message = exception.getMessage();
            code = exception.getCodeMessage().getCode();
        } else {
            message = ExceptionUtils.getRootCauseMessage((Throwable)e);
        }
        log.error(" Rest controller base exception ", (Throwable)e);
        if (this.properties.getStatusOutMode() == ResponseProperties.OutMode.Body) {
            if (result == null) {
                result = new Response();
            }
            result.put(this.properties.getCode(), (Object)code.value());
            result.put(this.properties.getMsg(), (Object)message);
        } else {
            response.setStatus(code.value());
            response.addHeader(this.properties.getMsg(), message);
        }
        return result;
    }

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        Response result = null;
        String requestId = MDC.get((String)"traceId");
        if (this.properties.getIdOutMode() == ResponseProperties.OutMode.Body) {
            result = body instanceof Response ? (Response)body : new Response();
            result.put(this.properties.getId(), (Object)requestId);
        } else {
            response.getHeaders().add(this.properties.getId(), requestId);
        }
        if (this.properties.getStatusOutMode() == ResponseProperties.OutMode.Body) {
            if (!(body instanceof Response)) {
                result = new Response();
                result.put(this.properties.getCode(), (Object)CodeConsts.SUCCESS.value());
                Response finalResult = result;
                Optional.ofNullable(body).ifPresent(b -> finalResult.put(this.properties.getResult(), b));
            } else {
                result = (Response)body;
                if (this.diffCode) {
                    result.put(this.properties.getCode(), result.get("bizvane-code"));
                    result.remove("bizvane-code");
                }
                if (this.diffResult && result.containsKey("bizvane-result")) {
                    result.put(this.properties.getResult(), result.get("bizvane-result"));
                    result.remove("bizvane-result");
                }
            }
        }
        return result == null ? body : result;
    }
}

