/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.common.response;

import com.bizvane.openapi.common.consts.CodeConsts;
import com.bizvane.openapi.common.exception.OpenApiException;
import com.bizvane.openapi.common.response.Response;
import com.bizvane.openapi.common.response.ResponseProperties;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;

@ControllerAdvice(annotations={RestController.class})
public class ReactiveRestControllerExpAdviceHandler {
    private static final Logger log = LoggerFactory.getLogger(ReactiveRestControllerExpAdviceHandler.class);
    private ResponseProperties properties = new ResponseProperties();
    private boolean diffCode;
    private boolean diffResult;

    public ReactiveRestControllerExpAdviceHandler() {
        this.diffProperties();
    }

    public ReactiveRestControllerExpAdviceHandler(ResponseProperties properties) {
        this.properties = properties;
        this.diffProperties();
    }

    private void diffProperties() {
        if (!"bizvane-code".equals(this.properties.getCode())) {
            this.diffCode = true;
        }
        if (!"bizvane-result".equals(this.properties.getResult())) {
            this.diffResult = true;
        }
    }

    @ExceptionHandler(value={Exception.class})
    public Response defaultExceptionHandler(Exception e, ServerWebExchange exchange) throws Exception {
        if (AnnotationUtils.findAnnotation(e.getClass(), ResponseStatus.class) != null) {
            throw e;
        }
        Response result = null;
        HttpStatus code = CodeConsts.SERVER_ERROR;
        String message = null;
        if (e instanceof OpenApiException) {
            OpenApiException exception = (OpenApiException)((Object)e);
            message = exception.getCodeMessage().getMsg();
            code = exception.getCodeMessage().getCode();
        } else {
            log.error(" Rest controller base exception ", (Throwable)e);
            message = ExceptionUtils.getRootCauseMessage((Throwable)e);
        }
        exchange.getResponse().setStatusCode(code);
        exchange.getResponse().getHeaders().add(this.properties.getMsg(), message);
        return result;
    }
}

