/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.common.response;

import com.bizvane.openapi.common.consts.CodeConsts;
import com.google.common.base.Strings;
import org.springframework.http.HttpStatus;

public class CodeMessage {
    private HttpStatus code;
    private String msg;
    private String description;
    private static final String PATTERN = "(\\{[a-zA-Z.-_]{0,}\\})";

    private CodeMessage() {
    }

    @Deprecated
    public CodeMessage(HttpStatus code, String msg) {
        this.code = code;
        this.msg = msg;
        this.description = msg;
    }

    private CodeMessage(HttpStatus code, String msg, String desc) {
        this.code = code;
        this.msg = msg;
        this.description = desc;
    }

    public static CodeMessage newInstance(HttpStatus code, String msg, String desc) {
        CodeMessage cm = new CodeMessage(code, msg, desc);
        return cm;
    }

    public static CodeMessage newInstance(HttpStatus code, String msg) {
        return CodeMessage.newInstance(code, msg, msg);
    }

    public static CodeMessage newClientInstance(String msg) {
        return CodeMessage.newInstance(CodeConsts.CLIENT_ERROR, msg);
    }

    public static CodeMessage newClientInstance(String msg, String desc) {
        return CodeMessage.newInstance(CodeConsts.CLIENT_ERROR, msg, desc);
    }

    public static CodeMessage newServerInstance(String msg) {
        return CodeMessage.newInstance(CodeConsts.SERVER_ERROR, msg);
    }

    public static CodeMessage newServerInstance(String msg, String desc) {
        return CodeMessage.newInstance(CodeConsts.SERVER_ERROR, msg, desc);
    }

    public static CodeMessage newInstance(CodeMessage cm, String ... args) {
        if (cm == null) {
            return null;
        }
        if (Strings.emptyToNull((String)cm.getMsg()) == null) {
            return cm;
        }
        String msg = cm.getMsg();
        if (args == null || args.length == 0) {
            msg.replaceAll(PATTERN, "");
        } else {
            for (String arg : args) {
                msg = msg.replaceFirst(PATTERN, arg);
            }
        }
        return CodeMessage.newInstance(cm.getCode(), msg);
    }

    public String toString() {
        return this.msg;
    }

    public HttpStatus getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getDescription() {
        return this.description;
    }

    public CodeMessage setCode(HttpStatus code) {
        this.code = code;
        return this;
    }

    public CodeMessage setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public CodeMessage setDescription(String description) {
        this.description = description;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CodeMessage)) {
            return false;
        }
        CodeMessage other = (CodeMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HttpStatus this$code = this.getCode();
        HttpStatus other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CodeMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpStatus $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

