/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.common.request;

import com.alibaba.fastjson.JSON;
import com.bizvane.openapi.common.consts.CodeMessageConsts;
import com.bizvane.openapi.common.exception.OpenApiException;
import com.bizvane.openapi.common.request.HttpRequest;
import com.bizvane.openapi.common.retrofit.HttpService;
import com.bizvane.openapi.common.utils.Assert;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class HttpRequestHandler
implements HttpRequest {
    private HttpService httpService;
    static final Map<String, Object> EMPTY_MAP = Maps.newHashMapWithExpectedSize((int)0);

    public HttpRequestHandler(HttpService httpService) {
        this.httpService = httpService;
    }

    @Override
    public <T> T request(String method, String url, Map<String, Object> body, Map<String, Object> queryParams, Map<String, Object> headers, Class<T> clazz) {
        Assert.hasText(method, CodeMessageConsts.Forward.HTTP_REQUEST_METHOD_EMPTY);
        Assert.hasText(url, CodeMessageConsts.Forward.HTTP_REQUEST_URL_EMPTY);
        Assert.notNull(clazz, CodeMessageConsts.Forward.HTTP_REQUEST_RESULT_CLASS_EMPTY);
        if (body == null) {
            body = EMPTY_MAP;
        }
        if (queryParams == null) {
            queryParams = EMPTY_MAP;
        }
        if (headers == null) {
            headers = EMPTY_MAP;
        }
        return this.asynRequestRetrofit(method, url, body, queryParams, headers, clazz);
    }

    private CompletableFuture<Object> getFuture(String method, String url, Map<String, Object> body, Map<String, Object> params, Map<String, Object> headers) {
        CompletableFuture<Object> future = null;
        switch (method.toLowerCase()) {
            case "post": {
                future = this.httpService.postBody(url, body, params, headers);
                break;
            }
            case "post_form": {
                future = this.httpService.post(url, body, params, headers);
                break;
            }
            case "put": {
                future = this.httpService.putBody(url, body, params, headers);
                break;
            }
            case "delete": {
                future = this.httpService.delete(url, params, headers);
                break;
            }
            default: {
                future = this.httpService.get(url, params, headers);
            }
        }
        return future;
    }

    public <T> T asynRequestRetrofit(String method, String url, Map<String, Object> body, Map<String, Object> params, Map<String, Object> headers, Class<T> clazz) {
        CompletableFuture<Object> future = this.getFuture(method, url, body, params, headers);
        try {
            Object result = future.get();
            if (result == null) {
                return null;
            }
            return (T)JSON.parseObject((String)JSON.toJSONString((Object)result), clazz);
        }
        catch (InterruptedException | ExecutionException e) {
            String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause != null && "HTTP 404".equals(rootCause.getMessage())) {
                throw OpenApiException.newInstance(CodeMessageConsts.Network.NETWORK_HTTP_NOT_FOUND);
            }
            throw OpenApiException.newInstanceWithRootCause(CodeMessageConsts.Network.NETWORK_REQUEST_ERROR, e);
        }
    }

    @Override
    public String get(String url) {
        return this.get(url, String.class);
    }

    @Override
    public <T> T get(String url, Class<T> clazz) {
        return this.get(url, null, null, clazz);
    }

    @Override
    public <T> T get(String url, Map<String, Object> params, Class<T> clazz) {
        return this.get(url, params, null, clazz);
    }

    @Override
    public <T> T get(String url, Map<String, Object> params, Map<String, Object> headers, Class<T> clazz) {
        return this.request("get", url, null, params, headers, clazz);
    }

    @Override
    public String postBody(String url) {
        return this.postBody(url, String.class);
    }

    @Override
    public <T> T postBody(String url, Class<T> clazz) {
        return this.postBody(url, null, null, null, clazz);
    }

    @Override
    public <T> T postBody(String url, Map<String, Object> body, Class<T> clazz) {
        return this.postBody(url, body, null, null, clazz);
    }

    @Override
    public <T> T postBody(String url, Map<String, Object> body, Map<String, Object> headers, Class<T> clazz) {
        return this.postBody(url, body, null, headers, clazz);
    }

    @Override
    public <T> T postBody(String url, Map<String, Object> body, Map<String, Object> queryParams, Map<String, Object> headers, Class<T> clazz) {
        return this.request("post", url, body, queryParams, headers, clazz);
    }

    @Override
    public <T> T post(String url, Class<T> clazz) {
        return this.post(url, null, clazz);
    }

    @Override
    public <T> T post(String url, Map<String, Object> params, Class<T> clazz) {
        return this.post(url, params, null, clazz);
    }

    @Override
    public <T> T post(String url, Map<String, Object> params, Map<String, Object> headers, Class<T> clazz) {
        return this.post(url, params, null, headers, clazz);
    }

    @Override
    public <T> T post(String url, Map<String, Object> params, Map<String, Object> queryParams, Map<String, Object> headers, Class<T> clazz) {
        return this.request("post_form", url, params, queryParams, headers, clazz);
    }

    @Override
    public String putBody(String url) {
        return this.putBody(url, String.class);
    }

    @Override
    public <T> T putBody(String url, Class<T> clazz) {
        return this.putBody(url, null, null, null, clazz);
    }

    @Override
    public <T> T putBody(String url, Map<String, Object> body, Class<T> clazz) {
        return this.putBody(url, body, null, null, clazz);
    }

    @Override
    public <T> T putBody(String url, Map<String, Object> body, Map<String, Object> headers, Class<T> clazz) {
        return this.putBody(url, body, null, headers, clazz);
    }

    @Override
    public <T> T putBody(String url, Map<String, Object> body, Map<String, Object> queryParams, Map<String, Object> headers, Class<T> clazz) {
        return this.request("put", url, body, queryParams, headers, clazz);
    }

    @Override
    public String delete(String url) {
        return this.delete(url, String.class);
    }

    @Override
    public <T> T delete(String url, Class<T> clazz) {
        return this.delete(url, null, null, clazz);
    }

    @Override
    public <T> T delete(String url, Map<String, Object> params, Class<T> clazz) {
        return this.delete(url, params, null, clazz);
    }

    @Override
    public <T> T delete(String url, Map<String, Object> params, Map<String, Object> headers, Class<T> clazz) {
        return this.request("delete", url, null, params, headers, clazz);
    }

    public HttpService getHttpService() {
        return this.httpService;
    }

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }
}

